package com.biz.crm.dms.business.order.verification.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

/**
 * 订单校验触发校验（注意：此接口仅用于模拟测试）
 *
 * @author pengxi
 * @date 2021/12/27
 */
@Slf4j
@Api(tags = "订单校验: orderVerification : 触发校验")
@RestController
@RequestMapping(value = {"/v1/orderVerification/common"})
public class OrderVerificationController {

  @Autowired(required = false)
  private ApplicationContext applicationContext;

  /**
   * 订单校验（注意：此接口仅用于模拟测试）
   */
  @Deprecated
  @ApiOperation(value = "订单校验（注意：此接口仅用于模拟测试）")
  @PostMapping("/handleValidate")
  public Result handleValidate(@RequestBody OrderDto orderDto) {
    // 系统设定订单必校验项
    Map<String, OrderMustVerificationStrategy> orderMustVerificationStrategyMap = applicationContext.getBeansOfType(OrderMustVerificationStrategy.class);
    orderMustVerificationStrategyMap.forEach((k, orderMustVerificationStrategy)-> {
      try {
      orderMustVerificationStrategy.execute(orderDto);
      } catch (Exception e) {
        log.error("执行订单校验策略：{} 时，发生异常：{}", k, e.getMessage(), e);
      } finally {
        log.info("已完成执订单校验策略：{}", orderMustVerificationStrategy.title());
      }
    });
    // 可选订单校验
    Map<String, OrderVerificationStrategy> orderVerificationStrategyMap = applicationContext.getBeansOfType(OrderVerificationStrategy.class);
    orderVerificationStrategyMap.forEach((k, orderVerificationStrategy)-> {
      try {
      orderVerificationStrategy.execute(orderDto);
      } catch (Exception e) {
        log.error("执行订单校验策略：{} 时，发生异常：{}", k, e.getMessage(), e);
      } finally {
        log.info("已完成执订单校验策略：{}", orderVerificationStrategy.title());
      }
    });
    return Result.ok();
  }

}
