package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailPayTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 促销政策达标校验 ，订单提交时，使用到的所有促销政策没有任何报错才可以。
 *
 * @author he fan
 */
@Component
public class SalePolicyStandardsVerificationStrategyImpl implements OrderMustVerificationStrategy {
  @Override
  public List<OrderValidationProcessNodeEnum> processNodeEnums() {
    return Lists.newArrayList(OrderValidationProcessNodeEnum.TEN);
  }

  @Override
  public List<OrderTypeEnum> orderTypeEnums() {
    return Lists.newArrayList(OrderTypeEnum.STANDARD);
  }

  @Override
  public Boolean required() {
    return Boolean.TRUE;
  }

  @Override
  public String title() {
    return "促销政策达标校验";
  }

  @Override
  public void execute(OrderVerificationContext orderVerificationContext) {

    /**
     * --在促销政策分摊之后执行的校验
     * --就看有没有错误信息，有错误信息就不让通过。
     */
    OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
    List<OrderDetailTabulateDto> orderDetails = orderTabulateDto.getOrderDetails();
    if (CollectionUtils.isEmpty(orderDetails)) {
      return;
    }
    for (OrderDetailTabulateDto orderDetail : orderDetails) {
      List<OrderDetailPayTabulateDto> orderDetailPays = orderDetail.getOrderDetailPays();
      if (CollectionUtils.isEmpty(orderDetailPays)) {
        continue;
      }
      List<String> errorReason = Lists.newLinkedList();
      for (OrderDetailPayTabulateDto orderDetailPay : orderDetailPays) {
        if (!orderDetailPay.getAvailable()) {
          String reason = orderDetailPay.getReason();
          errorReason.add(reason);
        }
      }
      Validate.isTrue(CollectionUtils.isEmpty(errorReason), StringUtils.join(errorReason, ",\n"));
    }








  }
}
