/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolDiscountVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    @Autowired(required=false)
    @Qualifier(value="costPoolDiscountStrategyImpl")
    private CostPoolStrategy costPoolStrategy;
    @Autowired(required=false)
    @Qualifier(value="CostPoolDiscountRegisterImpl")
    private CostPoolRegister costPoolRegister;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])new OrderTypeEnum[]{OrderTypeEnum.STANDARD, OrderTypeEnum.DISCOUNT});
    }

    public Boolean required() {
        return true;
    }

    public String title() {
        return "\u6298\u6263\u8d39\u7528\u6c60\u4f59\u989d\u6821\u9a8c";
    }

    public void execute(OrderDto orderContextDto) {
        Validate.notNull((Object)orderContextDto, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        String customerCode = orderContextDto.getRelateCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setCustomerCode(customerCode);
        costPoolDto.setPoolType(this.costPoolRegister.getKey());
        List costPoolVoList = this.costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        BigDecimal usableAmount = costPoolVoList.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = new BigDecimal(0);
        List orderPayments = orderContextDto.getOrderPays();
        if (CollectionUtils.isEmpty((Collection)orderPayments)) {
            return;
        }
        for (OrderPayDto orderPayment : orderPayments) {
            if (!orderPayment.getItemKey().equals("discount")) continue;
            amount = amount.add(orderPayment.getItemAmount());
        }
        Validate.isTrue((amount.compareTo(usableAmount) != 1 ? 1 : 0) != 0, (String)"\u6298\u6263\u8d39\u7528\u6c60\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
    }
}

