/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CreditOrderVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    private static final Logger log = LoggerFactory.getLogger(CreditOrderVerificationStrategyImpl.class);
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditStrategyImpl")
    private CostPoolStrategy costPoolStrategy;
    @Autowired(required=false)
    @Qualifier(value="CostPoolCreditRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    @Qualifier(value="CreditTallyItemRegister")
    private TallyItemRegister tallyItemRegister;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])new OrderTypeEnum[]{OrderTypeEnum.STANDARD});
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u6388\u4fe1\u8d26\u6237\u53ef\u7528\u4f59\u989d\u6821\u9a8c";
    }

    public void execute(OrderDto orderContextDto) {
        Validate.notNull((Object)orderContextDto, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        String customerCode = orderContextDto.getRelateCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setPoolType(this.costPoolRegister.getKey());
        costPoolDto.setCustomerCode(customerCode);
        List costPoolVoList = this.costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        BigDecimal usableAmount = costPoolVoList.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal amount = new BigDecimal(0);
        List payDtos = orderContextDto.getOrderPays().stream().filter(orderPayDto -> this.tallyItemRegister.findTallyItemRegisterModel().getItemKey().equals(orderPayDto.getItemKey())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(payDtos)) {
            BigDecimal reduce = payDtos.stream().map(OrderPayDto::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            amount = amount.add(reduce);
        }
        Validate.isTrue((usableAmount.compareTo(amount) >= 0 ? 1 : 0) != 0, (String)"\u6388\u4fe1\u8d44\u91d1\u4f59\u989d\u4e0d\u8db3", (Object[])new Object[0]);
    }
}

