/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LatestPriceVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TEN});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])OrderTypeEnum.values());
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u6700\u65b0\u4ef7\u683c\u9a8c\u8bc1";
    }

    public void execute(OrderVerificationContext context) {
        OrderDto orderDto = context.getOrderDto();
        String orderCategory = orderDto.getOrderCategory();
        if (orderCategory.equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            return;
        }
        List orderDetails = orderDto.getOrderDetails();
        Set productCodeSet = orderDetails.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getGoodsCode())).map(OrderDetailDto::getGoodsCode).collect(Collectors.toSet());
        FindPriceDto findPriceDto = new FindPriceDto();
        findPriceDto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
        findPriceDto.setUserCode(orderDto.getRelateCode());
        findPriceDto.setProductCodeSet(productCodeSet);
        Map priceMap = this.priceModelVoService.findPrice(findPriceDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Map)priceMap) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u4e2d\u6240\u6709\u5546\u54c1\u6ca1\u6709\u67e5\u8be2\u5230\u4ef7\u683c", (Object[])new Object[0]);
        List errorList = orderDetails.stream().filter(dto -> {
            String goodsCode = dto.getGoodsCode();
            PriceModelVo priceModelVo = (PriceModelVo)priceMap.get(goodsCode);
            Validate.notNull((Object)priceModelVo, (String)StringUtils.join((Object[])new String[]{"\u6ca1\u6709\u67e5\u8be2\u5230\u5546\u54c1\u4ef7\u683c:", dto.getGoodsCode()}), (Object[])new Object[0]);
            BigDecimal price = priceModelVo.getPrice();
            Validate.notNull((Object)price, (String)StringUtils.join((Object[])new String[]{"\u6ca1\u6709\u67e5\u8be2\u5230\u5546\u54c1\u4ef7\u683c:", dto.getGoodsCode()}), (Object[])new Object[0]);
            BigDecimal presetUnitPrice = dto.getPresetUnitPrice();
            Validate.notNull((Object)presetUnitPrice, (String)"\u6ca1\u6709\u5165\u53c2\u4ef7\u683c\uff1a", (Object[])new Object[]{dto.getGoodsCode()});
            boolean equal = presetUnitPrice.compareTo(price) == 0;
            return !equal;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(errorList)) {
            List goodsNames = errorList.stream().map(OrderDetailDto::getGoodsName).collect(Collectors.toList());
            String join = StringUtils.join(goodsNames, (String)"\u3001");
            String msg = StringUtils.join((Object[])new String[]{"\u8ba2\u5355\u5546\u54c1\u4e2d\uff1a", join, "\uff0c\u4ef7\u683c\u4e0d\u662f\u6700\u65b0\u4ef7\u683c"});
            throw new IllegalArgumentException(msg);
        }
    }
}

