/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.biz.crm.mdm.business.price.sdk.dto.FindPriceDto;
import com.biz.crm.mdm.business.price.sdk.enums.FindPriceUserTypeEnum;
import com.biz.crm.mdm.business.price.sdk.service.PriceModelVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceModelVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class LowestPriceOrderVerificationStrategyImpl
implements OrderVerificationStrategy {
    @Autowired(required=false)
    private PriceModelVoService priceModelVoService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TEN});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])new OrderTypeEnum[]{OrderTypeEnum.STANDARD});
    }

    public Boolean required() {
        return Boolean.FALSE;
    }

    public String title() {
        return "\u6700\u4f4e\u4ef7\u6821\u9a8c";
    }

    public void execute(OrderVerificationContext context) {
        Validate.notNull((Object)context, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notNull((Object)context.getOrderDto(), (String)"\u8ba2\u5355\u539f\u59cb\u62a5\u6587\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notNull((Object)context.getOrderConfigVo(), (String)"\u8ba2\u5355\u914d\u7f6e\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.notNull((Object)context.getOrderTabulateDto(), (String)"\u8ba2\u5355\u5206\u644a\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)context.getOrderTabulateDto().getOrderDetails()) ? 1 : 0) != 0, (String)"\u5206\u644a\u540e\u7684\u8ba2\u5355\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String customerCode = context.getOrderDto().getRelateCode();
        List orderDetails = context.getOrderTabulateDto().getOrderDetails();
        if (Boolean.FALSE.equals(context.getOrderConfigVo().getIsKneadingPrice()) && CollectionUtils.isEmpty(orderDetails = context.getOrderTabulateDto().getOrderDetails().stream().filter(a -> a.getItemType().equals(ItemTypeEnum.NORMAL_GOODS.getDictCode())).collect(Collectors.toList()))) {
            return;
        }
        Set productCodeSet = orderDetails.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getGoodsCode())).map(OrderDetailTabulateDto::getGoodsCode).collect(Collectors.toSet());
        Validate.isTrue((!CollectionUtils.isEmpty(productCodeSet) ? 1 : 0) != 0, (String)"\u8ba2\u5355\u660e\u7ec6\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        FindPriceDto dto = new FindPriceDto();
        dto.setPriceTypeCode((Set)Sets.newHashSet((Object[])new String[]{"lowest_price"}));
        dto.setProductCodeSet(productCodeSet);
        dto.setUserType(FindPriceUserTypeEnum.CUSTOMER.getDictCode());
        dto.setUserCode(customerCode);
        Map map = this.priceModelVoService.findPrice(dto);
        for (OrderDetailTabulateDto item : orderDetails) {
            BigDecimal lowestPrice;
            BigDecimal averageUnitPrice;
            if (!map.containsKey(item.getGoodsCode())) {
                Validate.isTrue((boolean)false, (String)StringUtils.join((Object[])new String[]{"\u5546\u54c1\u7f16\u7801", item.getGoodsCode(), "\u7684\u4ea7\u54c1\u672a\u914d\u7f6e\u6700\u4f4e\u4ef7"}), (Object[])new Object[0]);
            }
            Validate.isTrue(((averageUnitPrice = Optional.ofNullable(item.getAverageUnitPrice()).orElse(BigDecimal.ZERO)).compareTo(lowestPrice = Optional.ofNullable(((PriceModelVo)map.get(item.getGoodsCode())).getPrice()).orElse(BigDecimal.ZERO)) >= 0 ? 1 : 0) != 0, (String)StringUtils.join((Object[])new String[]{"\u5546\u54c1\u7f16\u7801", item.getGoodsCode(), "\u4f18\u60e0\u540e\u5355\u4ef7\u4f4e\u4e8e\u6700\u4f4e\u4ef7\uff01"}), (Object[])new Object[0]);
        }
    }
}

