/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailPayTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class SalePolicyStandardsVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TEN});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])new OrderTypeEnum[]{OrderTypeEnum.STANDARD});
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u4fc3\u9500\u653f\u7b56\u8fbe\u6807\u6821\u9a8c";
    }

    public void execute(OrderVerificationContext orderVerificationContext) {
        OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
        List orderDetails = orderTabulateDto.getOrderDetails();
        if (CollectionUtils.isEmpty((Collection)orderDetails)) {
            return;
        }
        for (OrderDetailTabulateDto orderDetail : orderDetails) {
            List orderDetailPays = orderDetail.getOrderDetailPays();
            if (CollectionUtils.isEmpty((Collection)orderDetailPays)) continue;
            LinkedList errorReason = Lists.newLinkedList();
            for (OrderDetailPayTabulateDto orderDetailPay : orderDetailPays) {
                if (orderDetailPay.getAvailable().booleanValue()) continue;
                String reason = orderDetailPay.getReason();
                errorReason.add(reason);
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)errorReason), (String)StringUtils.join((Iterable)errorReason, (String)",\n"), (Object[])new Object[0]);
        }
    }
}

