package com.biz.crm.dms.business.order.verification.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.dms.business.order.verification.sdk.vo.OrderValidateDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 获取订单校验提供者列表
 *
 * @author pengxi
 * @date 2021/12/27
 */
@Slf4j
@Api(tags = "订单校验: orderVerification : 提供者")
@RestController
@RequestMapping(value = {"/v1/orderVerification/provider"})
public class OrderVerificationStrategyController {

  @Autowired(required = false)
  private OrderVerificationService orderVerificationService;

  /**
   * 查询订单校验策略实现列表
   */
  @ApiOperation(value = "查询订单校验策略实现列表")
  @GetMapping("/findProviders")
  public Result<List<OrderValidateDetailVo>> findProviders(@RequestParam(value = "orderType") @ApiParam(name = "orderType", value = "订单类型", required = true) String orderType) {
    try {
      return Result.ok(this.orderVerificationService.findProviders(orderType));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
