package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Sets.SetView;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 允销商品校验实现
 *
 * @author sunx
 * @date 2022/1/12
 */
@Service
public class AllowSaleOrderVerificationStrategyImpl implements OrderMustVerificationStrategy {

  @Autowired(required = false) private AllowSaleListVoService allowSaleListVoService;

  @Override
  public List<OrderValidationProcessNodeEnum> processNodeEnums() {
    return Lists.newArrayList(OrderValidationProcessNodeEnum.ONE);
  }

  @Override
  public List<OrderTypeEnum> orderTypeEnums() {
    return Lists.newArrayList(OrderTypeEnum.values());
  }

  @Override
  public Boolean required() {
    return Boolean.TRUE;
  }

  @Override
  public String title() {
    return "允销商品校验";
  }

  @Override
  public void execute(OrderDto orderContextDto) {
    Validate.notNull(orderContextDto, "订单上下文信息缺失");
    String customerCode = orderContextDto.getRelateCode();
    Validate.notBlank(customerCode, "订单客户编码不能为空");
    Set<String> productCodeSet = orderContextDto.getOrderDetails().stream()
            .filter(a -> StringUtils.isNotBlank(a.getGoodsCode()) && ItemTypeEnum.NORMAL_GOODS.getDictCode().equals(a.getItemType()))
            .map(OrderDetailDto::getGoodsCode)
            .collect(Collectors.toSet());
    if (CollectionUtils.isEmpty(productCodeSet)) {
      return;
    }
    ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
    dto.setBusinessCode(customerCode);
    dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
    dto.setProductCodeList(Lists.newArrayList(productCodeSet));
    List<String> list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
    Validate.isTrue(!CollectionUtils.isEmpty(list), "对应的商品不可购");
    Set<String> set1 = Sets.newHashSet(list);
    SetView<String> difference = Sets.difference(productCodeSet, set1);
    if (!difference.isEmpty()) {
      Validate.isTrue(false, StringUtils.join(difference, ",") + "商品编码对应的商品不可购");
    }
  }
}
