package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.biz.crm.dms.business.order.verification.sdk.constant.CostPoolDiscountVerificationConstant;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author HanJiaJun
 * @describe: 折扣池校验
 * @createTime 2022年01月13日 11:23:00
 */
@Service
public class CostPoolDiscountVerificationStrategyImpl implements OrderMustVerificationStrategy {

  @Autowired(required = false)
  @Qualifier("costPoolDiscountStrategyImpl")
  private CostPoolStrategy costPoolStrategy;

  @Autowired(required = false)
  @Qualifier("CostPoolDiscountRegisterImpl")
  private CostPoolRegister costPoolRegister;

  @Override
  public List<OrderValidationProcessNodeEnum> processNodeEnums() {
    return Lists.newArrayList(OrderValidationProcessNodeEnum.THREE);
  }

  @Override
  public List<OrderTypeEnum> orderTypeEnums() {
    return Lists.newArrayList(OrderTypeEnum.STANDARD, OrderTypeEnum.DISCOUNT);
  }

  @Override
  public Boolean required() {
    return true;
  }

  @Override
  public String title() {
    return "折扣费用池余额校验";
  }

  @Override
  public void execute(OrderDto orderContextDto) {
    Validate.notNull(orderContextDto, "订单上下文信息缺失");
    String customerCode = orderContextDto.getRelateCode();
    Validate.notBlank(customerCode, "订单客户编码不能为空");
    CostPoolDto costPoolDto = new CostPoolDto();
    costPoolDto.setCustomerCode(customerCode);
    costPoolDto.setPoolType(this.costPoolRegister.getKey());
    //查询折扣池资金信息
    List<CostPoolVo> costPoolVoList = costPoolStrategy.onRequestCostPoolVos(costPoolDto);
    //汇总剩余可使用金额
    BigDecimal usableAmount = costPoolVoList.stream()
        .map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    BigDecimal amount = new BigDecimal(0);
    List<OrderPayDto> orderPayments = orderContextDto.getOrderPays();
    if(CollectionUtils.isEmpty(orderPayments)){
      return;
    }
    for (OrderPayDto orderPayment : orderPayments) {
      //判断是否是折扣费用
      if (orderPayment.getItemKey().equals(CostPoolDiscountVerificationConstant.DISCOUNT)) {
        amount = amount.add(orderPayment.getItemAmount());
      }
    }
    //比较
    Validate.isTrue(!(amount.compareTo(usableAmount) == 1), "折扣费用池余额不足");
  }
}
