package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDetailDto;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDto;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderTypeStrategy;
import com.biz.crm.dms.business.order.verification.sdk.vo.OrderValidateDetailVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 订单类型校验
 *
 * @author pengxi
 * @date 2021/12/30
 */
@Service
public class DefaultOrderTypeStrategyImpl implements OrderTypeStrategy {

  @Autowired(required = false)
  private OrderVerificationService orderVerificationService;

  @Override
  public void validate(String orderType, OrderValidateDto orderValidateDto) {
    if (StringUtils.isBlank(orderType) || Objects.isNull(orderValidateDto) || CollectionUtils.isEmpty(orderValidateDto.getDetailDtoList())) {
      return;
    }
    List<OrderValidateDetailVo> orderValidateDetailVos = this.orderVerificationService.findProviders(orderType);
    OrderTypeEnum orderTypeEnum = OrderTypeEnum.findByCode(orderType);
    Map<String, OrderValidateDetailDto> orderValidateDetailDtoMap = orderValidateDto.getDetailDtoList().stream().collect(Collectors.toMap(OrderValidateDetailDto::getName, o -> o));
    orderValidateDetailVos.forEach(v-> Validate.isTrue(orderValidateDetailDtoMap.containsKey(v.getName()), String.format("%s必须有%s", orderTypeEnum.getValue(), v.getTitle())));
  }
}
