/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.service.internal;

import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.exception.OrderVerificationException;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.biz.crm.dms.business.order.verification.sdk.vo.OrderValidateDetailVo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class OrderVerificationServiceImpl
implements OrderVerificationService {
    private static final Logger log = LoggerFactory.getLogger(OrderVerificationServiceImpl.class);
    @Autowired(required=false)
    private ApplicationContext applicationContext;

    public void execute(OrderVerificationContext context) {
        if (context == null) {
            log.warn("\u8ba2\u5355\u4e0a\u4e0b\u6587VO\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (context.getOrderDto() == null) {
            log.warn("\u8ba2\u5355\u539f\u59cb\u62a5\u6587\u4e0d\u80fd\u4e3a\u7a7a");
            return;
        }
        if (Objects.isNull(context.getOrderConfigVo()) || CollectionUtils.isEmpty((Collection)context.getOrderConfigVo().getVerificationVoList())) {
            log.warn("\u8ba2\u5355\u914d\u7f6e\u4e2d\u6ca1\u6709\u9700\u8981\u6267\u884c\u6821\u9a8c\u903b\u8f91\u7684\u7b56\u7565\u8bbe\u7f6e");
            return;
        }
        OrderValidationProcessNodeEnum processNodeEnum = context.getProcessNodeEnum();
        if (processNodeEnum == null) {
            log.warn("\u8ba2\u5355\u6821\u9a8c\u6d41\u7a0b\u8282\u70b9\u672a\u5b9a\u4e49");
            return;
        }
        Map orderMustVerificationStrategyMap = this.applicationContext.getBeansOfType(OrderMustVerificationStrategy.class);
        orderMustVerificationStrategyMap.forEach((k, orderMustVerificationStrategy) -> {
            try {
                if (CollectionUtils.isEmpty((Collection)orderMustVerificationStrategy.processNodeEnums())) {
                    log.warn("\u7cfb\u7edf\u8bbe\u5b9a\u8ba2\u5355\u5fc5\u6821\u9a8c[{}]\u672a\u6ce8\u518c", (Object)orderMustVerificationStrategy.title());
                    return;
                }
                if (orderMustVerificationStrategy.processNodeEnums().contains(processNodeEnum)) {
                    orderMustVerificationStrategy.execute(context);
                } else {
                    log.warn("\u8ba2\u5355\u6240\u5904\u8282\u70b9[{}]\u4e0d\u9700\u8981\u6267\u884c\u7cfb\u7edf\u8bbe\u5b9a\u6821\u9a8c[{}]", (Object)processNodeEnum.getValue(), (Object)orderMustVerificationStrategy.title());
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u7cfb\u7edf\u8bbe\u5b9a\u8ba2\u5355\u5fc5\u6821\u9a8c\u7b56\u7565\uff1a{} \u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a{}", new Object[]{orderMustVerificationStrategy.title(), e.getMessage(), e});
                throw new OrderVerificationException(e.getMessage());
            }
            finally {
                log.info("\u5df2\u5b8c\u6210\u7cfb\u7edf\u8bbe\u5b9a\u6267\u8ba2\u5355\u5fc5\u6821\u9a8c\u7b56\u7565\uff1a{}", (Object)orderMustVerificationStrategy.title());
            }
        });
        log.info("\u9700\u8981\u6267\u884c\u8ba2\u5355\u6821\u9a8c\u7b56\u7565\uff1a{}", (Object)context.getOrderConfigVo().getVerificationVoList());
        context.getOrderConfigVo().getVerificationVoList().forEach(strategy -> {
            try {
                if (strategy.getIsOpen().booleanValue()) {
                    OrderVerificationStrategy orderVerificationStrategy = (OrderVerificationStrategy)this.applicationContext.getBean(strategy.getName());
                    Validate.notNull((Object)orderVerificationStrategy, (String)String.format("\u6ca1\u6709\u627e\u5230\u5f53\u524d\u6821\u9a8c\u7b56\u7565\u5b9e\u73b0\uff1a%s", strategy.getTitle()), (Object[])new Object[0]);
                    if (CollectionUtils.isEmpty((Collection)orderVerificationStrategy.processNodeEnums())) {
                        log.warn("\u8ba2\u5355\u6821\u9a8c[{}]\u672a\u6ce8\u518c", (Object)orderVerificationStrategy.title());
                        return;
                    }
                    if (orderVerificationStrategy.processNodeEnums().contains(processNodeEnum)) {
                        orderVerificationStrategy.execute(context);
                    } else {
                        log.warn("\u8ba2\u5355\u6240\u5904\u8282\u70b9[{}]\u4e0d\u9700\u8981\u6267\u884c\u6821\u9a8c[{}]", (Object)processNodeEnum.getValue(), (Object)orderVerificationStrategy.title());
                    }
                } else {
                    log.warn("\u8df3\u8fc7\u5df2\u7981\u7528\u6821\u9a8c\u7b56\u7565\u5b9e\u73b0\uff1a{}", (Object)strategy.getTitle());
                }
            }
            catch (Exception e) {
                log.error("\u6267\u884c\u8ba2\u5355\u6821\u9a8c\u7b56\u7565\uff1a{} \u65f6\uff0c\u53d1\u751f\u5f02\u5e38\uff1a{}", new Object[]{strategy.getName(), e.getMessage(), e});
                throw new OrderVerificationException(e.getMessage());
            }
            finally {
                log.info("\u5df2\u5b8c\u6210\u6267\u8ba2\u5355\u6821\u9a8c\u7b56\u7565\uff1a{}", (Object)strategy.getName());
            }
        });
    }

    public List<OrderValidateDetailVo> findProviders(String orderType) {
        Map orderVerificationStrategyMap = this.applicationContext.getBeansOfType(OrderVerificationStrategy.class);
        log.info("\u83b7\u53d6\u8ba2\u5355\u6821\u9a8c\u63d0\u4f9b\u8005\u5217\u8868\u4fe1\u606f\uff1a{}", (Object)orderVerificationStrategyMap);
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.findByCode((String)orderType);
        Validate.notNull((Object)orderTypeEnum, (String)"\u8ba2\u5355\u7c7b\u578b\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        ArrayList orderValidateDetailVos = Lists.newArrayList();
        orderVerificationStrategyMap.forEach((s, strategy) -> {
            if (strategy.orderTypeEnums().contains(orderTypeEnum)) {
                OrderValidateDetailVo orderValidateDetailVo = new OrderValidateDetailVo();
                orderValidateDetailVo.setName(s);
                orderValidateDetailVo.setTitle(strategy.title());
                orderValidateDetailVo.setRequired(strategy.required());
                orderValidateDetailVos.add(orderValidateDetailVo);
            }
        });
        return orderValidateDetailVos;
    }
}

