/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.allow.sale.sdk.enums.AllowSaleListTypeEnums;
import com.biz.crm.dms.business.allow.sale.sdk.list.dto.ValidateAllowSaleProductDto;
import com.biz.crm.dms.business.allow.sale.sdk.list.service.AllowSaleListVoService;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AllowSaleOrderVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    @Autowired(required=false)
    private AllowSaleListVoService allowSaleListVoService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.ONE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])OrderTypeEnum.values());
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u5141\u9500\u5546\u54c1\u6821\u9a8c";
    }

    public void execute(OrderDto orderContextDto) {
        Validate.notNull((Object)orderContextDto, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        String customerCode = orderContextDto.getRelateCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Set productCodeSet = orderContextDto.getOrderDetails().stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getGoodsCode()) && ItemTypeEnum.NORMAL_GOODS.getDictCode().equals(a.getItemType())).map(OrderDetailDto::getGoodsCode).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(productCodeSet)) {
            return;
        }
        ValidateAllowSaleProductDto dto = new ValidateAllowSaleProductDto();
        dto.setBusinessCode(customerCode);
        dto.setListType(AllowSaleListTypeEnums.CUSTOMER.getCode());
        dto.setProductCodeList((List)Lists.newArrayList(productCodeSet));
        List list = this.allowSaleListVoService.findAllowSaleProductCodes(dto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)list) ? 1 : 0) != 0, (String)"\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u53ef\u8d2d", (Object[])new Object[0]);
        HashSet set1 = Sets.newHashSet((Iterable)list);
        Sets.SetView difference = Sets.difference(productCodeSet, (Set)set1);
        if (!difference.isEmpty()) {
            Validate.isTrue((boolean)false, (String)(StringUtils.join((Iterable)difference, (String)",") + "\u5546\u54c1\u7f16\u7801\u5bf9\u5e94\u7684\u5546\u54c1\u4e0d\u53ef\u8d2d"), (Object[])new Object[0]);
        }
    }
}

