/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.common.sdk.register.TallyItemRegister;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolCapitalVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    @Qualifier(value="costPoolCapitalStrategyImpl")
    private CostPoolStrategy costPoolStrategy;
    @Autowired(required=false)
    @Qualifier(value="CapitalTallyItemRegister")
    private TallyItemRegister tallyItemRegister;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Collections.singletonList(OrderTypeEnum.STANDARD);
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u6821\u9a8c";
    }

    public void execute(OrderVerificationContext orderVerificationContext) {
        boolean isZero;
        Validate.notNull((Object)orderVerificationContext, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)orderVerificationContext.getOrderDto(), (String)"\u8ba2\u5355\u4fe1\u606f\u7f3a\u5931\uff01", (Object[])new Object[0]);
        List orderPays = orderVerificationContext.getOrderDto().getOrderPays();
        if (CollectionUtils.isEmpty((Collection)orderPays)) {
            return;
        }
        String customerCode = orderVerificationContext.getOrderDto().getRelateCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal amount = BigDecimal.ZERO;
        List payDtos = orderPays.stream().filter(orderPayDto -> this.tallyItemRegister.findTallyItemRegisterModel().getItemKey().equals(orderPayDto.getItemKey())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(payDtos)) {
            BigDecimal reduce = payDtos.stream().map(OrderPayDto::getItemAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            amount = amount.add(reduce);
        }
        boolean bl = isZero = amount.compareTo(BigDecimal.ZERO) == 0;
        if (isZero) {
            return;
        }
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setPoolType(this.costPoolRegister.getKey());
        costPoolDto.setCustomerCode(customerCode);
        List costPoolVos = this.costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)costPoolVos) ? 1 : 0) != 0, (String)"\u8be5\u8ba2\u5355\u4f7f\u7528\u4e86\u8d44\u91d1\uff0c\u4f46\u5ba2\u6237\u4e0d\u5b58\u5728\u8d44\u91d1\u6c60\u4fe1\u606f\uff01", (Object[])new Object[0]);
        BigDecimal usableAmount = costPoolVos.stream().map(CostPoolVo::getUsableAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        Validate.isTrue((amount.compareTo(usableAmount) <= 0 ? 1 : 0) != 0, (String)"\u8d44\u91d1\u8d26\u6237\u4f59\u989d\u4e0d\u8db3!", (Object[])new Object[0]);
    }
}

