/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.dms.business.costpool.sdk.dto.CostPoolDto;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolRegister;
import com.biz.crm.dms.business.costpool.sdk.strategy.CostPoolStrategy;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolReplenishmentVerifyProductVo;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolReplenishmentVerifyVo;
import com.biz.crm.dms.business.costpool.sdk.vo.CostPoolVo;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.ItemTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CostPoolReplenishmentProductVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    private static final String ERROR_MESSAGE_SHELF = "\u5546\u54c1\u5df2\u4e0b\u67b6";
    private static final String ERROR_MESSAGE_EXIST = "\u4ea7\u54c1\u7f16\u7801\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5ba2\u6237\u7684\u8d27\u8865\u6c60";
    @Autowired(required=false)
    @Qualifier(value="costPoolReplenishmentStrategyImpl")
    private CostPoolStrategy costPoolStrategy;
    @Autowired(required=false)
    @Qualifier(value="CostPoolReplenishmentRegisterImpl")
    private CostPoolRegister costPoolRegister;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.ONE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])OrderTypeEnum.values());
    }

    public Boolean required() {
        return true;
    }

    public String title() {
        return "\u65b0\u589e\u8d27\u8865\u5546\u54c1\u6821\u9a8c";
    }

    public void execute(OrderDto orderContextDto) {
        List voLists;
        Validate.notNull((Object)orderContextDto, (String)"\u8ba2\u5355\u4e0a\u4e0b\u6587\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        String customerCode = orderContextDto.getRelateCode();
        Validate.notBlank((CharSequence)customerCode, (String)"\u8ba2\u5355\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List detailList = orderContextDto.getOrderDetails();
        List compensatedGoods = detailList.stream().filter(s -> s.getItemType().equals(ItemTypeEnum.COMPENSATED_GOODS.getDictCode())).collect(Collectors.toList());
        List poolCodes = compensatedGoods.stream().filter(s -> StringUtils.isNotBlank((CharSequence)s.getItemCode())).map(OrderDetailDto::getItemCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(compensatedGoods)) {
            return;
        }
        Validate.isTrue((compensatedGoods.size() == poolCodes.size() ? 1 : 0) != 0, (String)"\u5b58\u5728\u8d27\u8865\u5546\u54c1\u6ca1\u6709\u4f20\u5165\u8d27\u8865\u6c60\u7f16\u53f7", (Object[])new Object[0]);
        CostPoolDto costPoolDto = new CostPoolDto();
        costPoolDto.setPoolCodeList(poolCodes);
        costPoolDto.setCustomerCode(customerCode);
        costPoolDto.setPoolType(this.costPoolRegister.getKey());
        List costPoolVoList = this.costPoolStrategy.onRequestCostPoolVos(costPoolDto);
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)costPoolVoList) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u6c60\u4fe1\u606f", (Object[])new Object[0]);
        ArrayList<Object> costPoolReplenishmentVerifyVos = new ArrayList<Object>();
        for (CostPoolVo vo : costPoolVoList) {
            Object costPoolReplenishmentProduct = new CostPoolReplenishmentVerifyVo();
            costPoolReplenishmentProduct = (CostPoolReplenishmentVerifyVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)vo, CostPoolReplenishmentVerifyVo.class, HashSet.class, ArrayList.class, new String[]{"costPoolReplenishmentProduct"});
            costPoolReplenishmentVerifyVos.add(costPoolReplenishmentProduct);
        }
        ArrayList<String> noProductPoolCodes = new ArrayList<String>();
        ArrayList productVoCodes = new ArrayList();
        for (CostPoolReplenishmentVerifyVo costPoolReplenishmentVerifyVo : costPoolReplenishmentVerifyVos) {
            List product = costPoolReplenishmentVerifyVo.getCostPoolReplenishmentProduct();
            if (CollectionUtils.isEmpty((Collection)product)) {
                noProductPoolCodes.add(costPoolReplenishmentVerifyVo.getPoolCode());
                continue;
            }
            productVoCodes.addAll(product.stream().map(CostPoolReplenishmentVerifyProductVo::getGoodsProductCode).collect(Collectors.toList()));
        }
        List<Object> goodsCodes = new ArrayList();
        ArrayList<OrderDetailDto> arrayList = new ArrayList<OrderDetailDto>();
        ArrayList productList = new ArrayList();
        if (CollectionUtils.isEmpty(noProductPoolCodes)) {
            goodsCodes = compensatedGoods.stream().map(OrderDetailDto::getGoodsCode).collect(Collectors.toList());
        } else {
            Map<String, List<OrderDetailDto>> map = compensatedGoods.stream().collect(Collectors.groupingBy(OrderDetailDto::getItemCode));
            for (String code : noProductPoolCodes) {
                List<OrderDetailDto> orderDetailDtos = map.get(code);
                arrayList.addAll(orderDetailDtos);
            }
            noProductPoolCodes.forEach(e -> map.remove(e));
            map.forEach((k, v) -> productList.addAll(v));
            if (!CollectionUtils.isEmpty(productList)) {
                goodsCodes = productList.stream().map(OrderDetailDto::getGoodsCode).collect(Collectors.toList());
            }
        }
        HashMap<String, ArrayList> errorMap = new HashMap<String, ArrayList>();
        ArrayList<Object> copyFirstProCodes = new ArrayList<Object>();
        copyFirstProCodes.addAll(goodsCodes);
        ArrayList validateList = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(goodsCodes)) {
            for (String goodsCode : goodsCodes) {
                if (productVoCodes.contains(goodsCode)) continue;
                validateList.add(goodsCode);
                copyFirstProCodes.remove(goodsCode);
            }
        }
        errorMap.put(ERROR_MESSAGE_EXIST, validateList);
        if (!CollectionUtils.isEmpty(arrayList)) {
            copyFirstProCodes.addAll(arrayList.stream().map(OrderDetailDto::getGoodsCode).collect(Collectors.toList()));
        }
        Validate.isTrue((!CollectionUtils.isEmpty((Collection)(voLists = this.productVoService.findDetailsByIdsOrProductCodes(new ArrayList(0), copyFirstProCodes))) ? 1 : 0) != 0, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u8d27\u8865\u5546\u54c1\u4fe1\u606f", (Object[])new Object[0]);
        Set codes = voLists.stream().filter(o -> o.getIsShelf().equals(BooleanEnum.TRUE.getCapital())).map(ProductVo::getProductCode).collect(Collectors.toSet());
        HashSet<Object> copySecondProCodes = new HashSet<Object>();
        copySecondProCodes.addAll(copyFirstProCodes);
        ArrayList validateShellList = Lists.newArrayList();
        for (String string : copyFirstProCodes) {
            if (codes.contains(string)) continue;
            validateShellList.add(string);
            copySecondProCodes.remove(string);
        }
        errorMap.put(ERROR_MESSAGE_SHELF, validateShellList);
        if (!CollectionUtils.isEmpty((Collection)((Collection)errorMap.get(ERROR_MESSAGE_SHELF))) || !CollectionUtils.isEmpty((Collection)((Collection)errorMap.get(ERROR_MESSAGE_EXIST)))) {
            String errorMessage = "";
            for (Map.Entry entry : errorMap.entrySet()) {
                String key = (String)entry.getKey();
                List value = (List)entry.getValue();
                errorMessage = StringUtils.join((Object[])new String[]{errorMessage, key});
                String join = StringUtils.join((Iterable)value, (String)"\u3001");
                errorMessage = StringUtils.join((Object[])new String[]{errorMessage, join, "\n"});
            }
            Validate.isTrue((boolean)CollectionUtils.isEmpty(errorMap), (String)errorMessage, (Object[])new Object[0]);
        }
    }
}

