/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDetailDto;
import com.biz.crm.dms.business.order.verification.sdk.dto.OrderValidateDto;
import com.biz.crm.dms.business.order.verification.sdk.service.OrderVerificationService;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderTypeStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DefaultOrderTypeStrategyImpl
implements OrderTypeStrategy {
    @Autowired(required=false)
    private OrderVerificationService orderVerificationService;

    public void validate(String orderType, OrderValidateDto orderValidateDto) {
        if (StringUtils.isBlank((CharSequence)orderType) || Objects.isNull(orderValidateDto) || CollectionUtils.isEmpty((Collection)orderValidateDto.getDetailDtoList())) {
            return;
        }
        List orderValidateDetailVos = this.orderVerificationService.findProviders(orderType);
        OrderTypeEnum orderTypeEnum = OrderTypeEnum.findByCode((String)orderType);
        Map<String, OrderValidateDetailDto> orderValidateDetailDtoMap = orderValidateDto.getDetailDtoList().stream().collect(Collectors.toMap(OrderValidateDetailDto::getName, o -> o));
        orderValidateDetailVos.forEach(v -> Validate.isTrue((boolean)orderValidateDetailDtoMap.containsKey(v.getName()), (String)String.format("%s\u5fc5\u987b\u6709%s", orderTypeEnum.getValue(), v.getTitle()), (Object[])new Object[0]));
    }
}

