/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderPayDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderMustVerificationStrategy;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.stereotype.Component;

@Component
public class PaymentCompleteVerificationStrategyImpl
implements OrderMustVerificationStrategy {
    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.TEN});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])new OrderTypeEnum[]{OrderTypeEnum.STANDARD, OrderTypeEnum.REPLENISHMENT, OrderTypeEnum.DISCOUNT});
    }

    public Boolean required() {
        return Boolean.TRUE;
    }

    public String title() {
        return "\u5e94\u4ed8\u91d1\u989d\u652f\u4ed8\u5b8c\u6210\u6821\u9a8c";
    }

    public void execute(OrderVerificationContext orderVerificationContext) {
        OrderTabulateDto orderTabulateDto = orderVerificationContext.getOrderTabulateDto();
        OrderDto orderDto = orderVerificationContext.getOrderDto();
        String orderCategory = orderDto.getOrderCategory();
        if (orderCategory.equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            return;
        }
        String orderType = orderDto.getOrderType();
        boolean isFree = OrderTypeEnum.FREE.getDictCode().equals(orderType);
        if (isFree) {
            return;
        }
        List orderPays = orderDto.getOrderPays();
        BigDecimal totalOrderAmount = orderTabulateDto.getTotalOrderAmount();
        BigDecimal policyDiscountAmount = orderTabulateDto.getPolicyDiscountAmount();
        BigDecimal totalCompensatedAmount = orderTabulateDto.getTotalCompensatedAmount();
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        for (Object orderPay : orderPays) {
            Boolean itemGroupType = orderPay.getItemGroupType();
            if (itemGroupType.booleanValue()) continue;
            BigDecimal itemAmount = orderPay.getItemAmount();
            itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
            totalDiscountAmount = totalDiscountAmount.add(itemAmount);
        }
        BigDecimal totalPaymentAmount = BigDecimal.ZERO;
        for (OrderPayDto orderPay : orderPays) {
            Boolean itemGroupType = orderPay.getItemGroupType();
            if (!itemGroupType.booleanValue()) continue;
            BigDecimal itemAmount = orderPay.getItemAmount();
            itemAmount = Objects.nonNull(itemAmount) ? itemAmount : BigDecimal.ZERO;
            totalPaymentAmount = totalPaymentAmount.add(itemAmount);
        }
        BigDecimal amountPayable = totalOrderAmount.subtract(policyDiscountAmount).subtract(totalCompensatedAmount).subtract(totalDiscountAmount);
        int compare = amountPayable.compareTo(totalPaymentAmount);
        Validate.isTrue((compare == 0 ? 1 : 0) != 0, (String)"\u5e94\u4ed8\u91d1\u989d\u4e0e\u5b9e\u9645\u652f\u4ed8\u91d1\u989d\u4e0d\u76f8\u7b49", (Object[])new Object[0]);
    }
}

