/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dms.business.order.verification.local.strategy.internal;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDetailDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderCategoryEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.strategy.OrderVerificationStrategy;
import com.biz.crm.dms.business.psi.product.sdk.service.productstock.ProductStockVoService;
import com.biz.crm.dms.business.psi.product.sdk.vo.productstock.ProductStockVo;
import com.biz.crm.mdm.business.warehouse.sdk.service.WarehouseVoService;
import com.biz.crm.mdm.business.warehouse.sdk.vo.WarehouseVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StockOrderVerificationStrategyImpl
implements OrderVerificationStrategy {
    @Autowired(required=false)
    private WarehouseVoService warehouseVoService;
    @Autowired(required=false)
    private ProductStockVoService productStockVoService;

    public List<OrderValidationProcessNodeEnum> processNodeEnums() {
        return Lists.newArrayList((Object[])new OrderValidationProcessNodeEnum[]{OrderValidationProcessNodeEnum.THREE});
    }

    public List<OrderTypeEnum> orderTypeEnums() {
        return Lists.newArrayList((Object[])OrderTypeEnum.values());
    }

    public Boolean required() {
        return Boolean.FALSE;
    }

    public String title() {
        return "\u5e93\u5b58\u53ef\u7528\u6027\u6821\u9a8c";
    }

    public void execute(OrderDto orderDto) {
        Iterator<Object> iterator;
        HashMap<String, BigDecimal> productMap = new HashMap<String, BigDecimal>();
        BigDecimal quantity = BigDecimal.ZERO;
        for (OrderDetailDto vo : orderDto.getOrderDetails()) {
            quantity = productMap.containsKey(vo.getGoodsCode()) ? ((BigDecimal)productMap.get(vo.getGoodsCode())).add(vo.getQuantity()) : vo.getQuantity();
            productMap.put(vo.getGoodsCode(), quantity);
        }
        Validate.notBlank((CharSequence)orderDto.getCityCode(), (String)"\u5e93\u5b58\u53ef\u7528\u6027\u6821\u9a8c\u65f6\uff0c\u5e02\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        WarehouseVo warehouse = null;
        if (orderDto.getOrderCategory().equals(OrderCategoryEnum.MATERIAL_ORDER.getDictCode())) {
            String warehouseCode = orderDto.getWarehouseCode();
            warehouse = this.warehouseVoService.findDetailsByCode(warehouseCode);
        } else {
            warehouse = this.warehouseVoService.findDetailsByCityCode(orderDto.getCityCode());
            if (warehouse == null) {
                Boolean bool = true;
                warehouse = this.warehouseVoService.findDetailsByWarehouseDefault(bool);
            }
        }
        List productStockVos = this.productStockVoService.findByWarehouseAndProducts(warehouse.getWarehouseCode(), productMap.keySet());
        if (productStockVos.size() != productMap.keySet().size() && (iterator = productMap.keySet().iterator()).hasNext()) {
            String key = (String)iterator.next();
            Boolean flag = false;
            for (ProductStockVo vo : productStockVos) {
                if (!vo.getProductCode().equals(key)) continue;
                flag = true;
                break;
            }
            Validate.isTrue((boolean)flag, (String)"\u4ed3\u5e93%s\uff0c\u65e0\u5546\u54c1%s\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{warehouse.getWarehouseCode(), key});
        }
        for (ProductStockVo vo : productStockVos) {
            BigDecimal bigDecimal = productMap.get(vo.getProductCode()) == null ? BigDecimal.ZERO : (BigDecimal)productMap.get(vo.getProductCode());
            Validate.isTrue((vo.getAvailableStock().compareTo(bigDecimal) != -1 ? 1 : 0) != 0, (String)"\u5546\u54c1%s\uff0c\u5e93\u5b58\u4e0d\u8db3", (Object[])new Object[]{vo.getProductCode()});
        }
    }
}

