package com.biz.crm.dms.business.order.verification.sdk.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 订单配置Dto
 *
 * @author pengxi
 * @date 2021/12/29
 */
@Data
@ApiModel(value = "OrderValidateDto", description = "订单配置Dto")
public class OrderValidateDto {

  /**
   * 订单类型
   */
  @ApiModelProperty("订单类型")
  private String orderType;

  /**
   * 是否默认设定
   *  1.1默认设定：订单类型作为唯一校验，订单类型选择重复了则不允许提交
   *  1.2非默认设定：订单类型+配置生效的客户编码/组织编码作为唯一校验，不能重复
   */
  @ApiModelProperty("是否默认设定")
  private Boolean isDefault;

  /**
   * 生效类型：客户 customer；组织 org
   */
  @ApiModelProperty("生效类型：客户 customer；组织 org")
  private String effectiveType;

  /**
   * 是否揉价
   */
  @ApiModelProperty("是否揉价")
  private Boolean isKneadingPrice;

  /**
   * 揉价策略实现类名称
   */
  @ApiModelProperty("揉价策略实现类名称")
  private String kneadingPriceName;

  /**
   * 是否拆单
   */
  @ApiModelProperty("是否拆单")
  private Boolean isSplitOrder;

  /**
   * 拆单策略实现类名称
   */
  @ApiModelProperty("拆单策略实现类名称")
  private String splitOrderName;

  /**
   * 订单校验策略实现集合DTO
   */
  @ApiModelProperty("订单校验策略实现集合DTO")
  private List<OrderValidateDetailDto> detailDtoList;
}
