package com.biz.crm.dms.business.order.verification.sdk.model;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.dto.OrderTabulateDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.common.sdk.vo.OrderConfigVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Map;

/**
 * 订单校验上下文
 *
 * @author pengxi
 */
@Data
@ApiModel(value = "OrderVerificationContext", description = "订单校验上下文")
public class OrderVerificationContext {

  /**
   * 订单校验流程节点
   */
  @ApiModelProperty("订单校验流程节点")
  private OrderValidationProcessNodeEnum processNodeEnum;

  /**
   * 订单配置信息，里面包含具体配置校验项
   */
  @ApiModelProperty("订单配置信息，里面包含具体配置校验项")
  private OrderConfigVo orderConfigVo;

  /**
   * 订单原始报文
   */
  @ApiModelProperty("订单原始报文")
  private OrderDto orderDto;

  /**
   * 订单分摊计算后的vo
   */
  private OrderTabulateDto orderTabulateDto;

  /**
   * 扩展信息
   */
  @ApiModelProperty("扩展信息")
  private Map<String, Object> extend;
}
