package com.biz.crm.dms.business.order.verification.sdk.service;

import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.biz.crm.dms.business.order.verification.sdk.vo.OrderValidateDetailVo;

import java.util.List;

/**
 * 执行订单校验统一接口
 *
 * @author pengxi
 * @date 2021/12/29
 */
public interface OrderVerificationService {
  /**
   * 执行订单校验
   *
   * @param context 所处流程节点
   */
  void execute(OrderVerificationContext context);

  /**
   * 查询订单校验策略实现列表
   *
   * @param orderType 订单类型
   * @return List<OrderValidateDetailVo>
   */
  List<OrderValidateDetailVo> findProviders(String orderType);
}
