package com.biz.crm.dms.business.order.verification.sdk.strategy;

import com.biz.crm.dms.business.order.common.sdk.dto.OrderDto;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderTypeEnum;
import com.biz.crm.dms.business.order.common.sdk.enums.OrderValidationProcessNodeEnum;
import com.biz.crm.dms.business.order.verification.sdk.model.OrderVerificationContext;
import com.google.common.collect.Lists;

import java.util.List;

/**
 * 订单必校验统一接口（即不需要在订单配置页面管理的订单必须校验项）
 *
 * @author pengxi
 * @date 2022/03/02
 */
public interface OrderMustVerificationStrategy {

  /**
   * 对哪些流程节点做校验（梳理整个下单过程，定义出来的流程节点）
   *
   * @return List<OrderValidationProcessNodeEnum>
   */
  default List<OrderValidationProcessNodeEnum> processNodeEnums() {
    return Lists.newArrayList(OrderValidationProcessNodeEnum.values());
  };

  /**
   * 对哪些订单类型做校验
   *
   * @return List<OrderTypeEnum>
   */
  List<OrderTypeEnum> orderTypeEnums();

  /**
   * 是否设定为必须校验项（不接受页面选择是否开启）
   *
   * @return Boolean true 是，false 否
   */
  Boolean required();

  /**
   * 订单校验标题，请在目前需求确定列表中做出选择：
   *
   * 促销政策达标校验
   * 折扣费用池余额校验
   * 货补费用池余额校验
   * 资金账户余额校验
   * 授信账户可用余额校验
   * 应付金额支付完成校验
   * 费用池使用比例校验
   * 整单费比校验
   * 起订量校验
   * 库存可用性校验
   * 最低价校验
   *
   * @return String
   */
  String title();

  /**
   * 订单校验执行具体接口实现
   *
   * @param orderContextDto 订单上下文VO
   */
  default void execute(OrderDto orderContextDto) {
  }

  /**
   * 订单校验执行具体接口实现（需要订单配置信息的实现此方法）
   *
   * @param context 订单校验上下文
   */
  default void execute(OrderVerificationContext context) {
    this.execute(context.getOrderDto());
  }
}
