package com.biz.crm.dms.business.policy.local.controller;

import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyExecuteStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyExecutorInfo;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 该http层功能提供的接口，都与优惠政策执行策略方式信息有关
 * @author yinwenjie
 */
@Api(tags = "该http层功能提供的接口，都与优惠政策执行策略方式信息有关")
@RestController
@RequestMapping("/v1/salepolicies/executorstrategy")
public class SalePolicyExecutorStrategyController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyExecutorStrategyController.class);
  @Autowired(required = false)
  private Set<SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo>> salePolicyExecuteStrategies;
  
  @ApiOperation(value = "")
  @GetMapping(value="/findByExecutorStrategyCodes")
  public Result<?> findByExecuteStrategyCodes(@RequestParam("executorStrategyCode") @ApiParam(name = "executorStrategyCode" , required = true , value = "指定的优惠政策执行策略编号（可以传入一个或者多个）") String[] executorStrategyCodes) {
    try {
      JSONArray resutls = new JSONArray();
      for (SalePolicyExecuteStrategy<? extends AbstractSalePolicyExecutorInfo> salePolicyExecuteStrategy : salePolicyExecuteStrategies) {
        // 组装那些满足要求的优惠政策执行策略
        String executeStrategyCode = salePolicyExecuteStrategy.getExecuteStrategyCode();
        if(!ArrayUtils.contains(executorStrategyCodes , executeStrategyCode)) {
          continue;
        }
        String executeStrategyDesc = salePolicyExecuteStrategy.getExecuteStrategyDesc();
        String expression = salePolicyExecuteStrategy.getExpression();
        JSONObject item = new JSONObject();
        item.put("executeStrategyCode", executeStrategyCode);
        item.put("executeStrategyDesc", executeStrategyDesc);
        item.put("expression", expression);
        resutls.add(item);
      }
      return Result.ok(resutls);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
