package com.biz.crm.dms.business.policy.local.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * TODO 该接口用于测试，要进行删除的
 * @author yinwenjie
 */
@RestController
@RequestMapping("/v1/salepolicies/records")
public class SalePolicyRecordController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(SalePolicyRecordController.class);
  /**
   * 现在系统中支持的所有优惠政策注册信息
   */
  @Autowired(required = false)
  private SalePolicyRecordService salePolicyRecordService;
  
  @PostMapping(value="/deleteByBillCode")
  public Result<?> deleteByBillCode(@RequestParam("billCode") String billCode ,
                                    @RequestParam("customerCode") String customerCode) {
    try {
      String tenantCode = TenantUtils.getTenantCode();
      salePolicyRecordService.deleteByBillCode(billCode, tenantCode, customerCode);
      return Result.ok();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return Result.error(e.getMessage());
    }
  }
}
