package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import java.util.Set;

/**
 * 促销政策/优惠政策 标品方式中支持的执行规则，注意一个优惠优惠政策可能涉及多种执行规则，每种执行规则又可能对应一种多种商品
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_executor")
@Entity
@Table(name = "dms_sale_policy_executor" , indexes = {@Index(columnList = "sale_policy_code , tenant_code , executor_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_executor", comment = "促销政策/优惠政策 标品方式中支持的执行规则")
public class SalePolicyExecutor extends TenantEntity {
  private static final long serialVersionUID = -3941772683050842091L;
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 优惠政策执行策略业务编码，全系统唯一。可以直接使用salePolicyCode，也可以使用商品编号+salePolicyCode。反正需要保证全系统唯一(二级租户隔离)
   */
  @Column(name = "executor_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策执行策略业务编码，全系统唯一(二级租户隔离)。'")
  @ApiModelProperty("优惠政策执行策略业务编码，全系统唯一（二级租户隔离）。")
  private String executorCode;
  /**
   * 这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应
   */
  @Column(name = "execute_strategy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应'")
  @ApiModelProperty("这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应。")
  private String executeStrategyCode;
  /**
   * 优惠政策选定的“阶梯循环规则”，参见SalePolicyCycleRuleStrategy接口的具体描述
   */
  @Column(name = "cycle_rule_code" , length = 255 , nullable = false, columnDefinition = "VARCHAR(255) COMMENT '优惠政策选定的“阶梯循环规则”'")
  @ApiModelProperty("优惠政策选定的“阶梯循环规则”，参见SalePolicyCycleRuleStrategy接口的具体描述")
  private String cycleRuleCode;
  /**
   * 该执行规则对应的阶梯情况（至少有一个阶梯）
   */
  @OneToMany(fetch = FetchType.LAZY , mappedBy = "salePolicyExecutor")
  @ApiModelProperty(" 该执行规则对应的阶梯情况（至少有一个阶梯）")
  @TableField(exist = false)
  private Set<SalePolicyExecutorLadder> salePolicyExecutorLadders;
}