package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 促销政策/销售策略 使用的促销类型中 所设定的 政策类型执行器 的赠品
 * @author songjingen
 */
@Getter
@Setter
@TableName("dms_sale_policy_executor_ladder_gift")
@Entity
@Table(name = "dms_sale_policy_executor_ladder_gift" , indexes = @Index(columnList = "executor_ladder_id , gift_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_executor_ladder_gift", comment = "政策类型执行器下的赠品信息")
public class SalePolicyExecutorLadderGift extends UuidEntity {
  private static final long serialVersionUID = -3941772683050842091L;
  /**
   * 关联的优惠政策阶梯信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "executor_ladder_id" , nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("关联的优惠政策阶梯信息")
  private SalePolicyExecutorLadder executorLadder;
  
  @Column(name = "executor_ladder_id" , length = 255 , nullable = false , insertable = false , updatable = false , columnDefinition = "VARCHAR(255) COMMENT '关联的优惠政策阶梯信息的技术编号'")
  @ApiModelProperty("关联的优惠政策阶梯信息的技术编号(注意，通过JPA时，只能只读)")
  private String executorLadderId;
  /**
   * 赠品编码
   */
  @Column(name = "gift_code" , nullable = false , length = 32, columnDefinition = "VARCHAR(64) COMMENT '赠品编码'")
  @ApiModelProperty("赠品编码")
  private String giftCode;
  /**
   * 赠品名称
   */
  @Column(name = "gift_name" , nullable = false , length = 255, columnDefinition = "VARCHAR(255) COMMENT '赠品名称'")
  @ApiModelProperty("赠品名称")
  private String giftName;
  /**
   * 赠品类型。1：赠送数量；2：赠送金额
   */
  @Column(name = "gift_type" , nullable = false , length = 32, columnDefinition = "INT(11) COMMENT '赠品编码'")
  @ApiModelProperty("赠品类型。1：赠送数量；2：赠送金额")
  private Integer giftType;
  /**
   * 赠送值，如果赠品类型（giftType）为1，则这里表示赠送数量；如果赠品类型（giftType）为2，则这里表示赠送金额
   */
  @Column(name = "gift_value" , nullable = false, columnDefinition = "INT(11) COMMENT '赠送值，如果赠品类型（giftType）为1，则这里表示赠送数量；如果赠品类型（giftType）为2，则这里表示赠送金额'")
  @ApiModelProperty("赠送值，如果赠品类型（giftType）为1，则这里表示赠送数量；如果赠品类型（giftType）为2，则这里表示赠送金额")
  private Integer giftValue;
}