package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import java.util.Set;

/**
 * 促销政策/优惠政策 所绑定的限量政策，优惠政策能绑定的限量政策通过SalePolicyRegister的具体实现进行确认；</br>
 * 但最终绑定的限量政策（业务编号）会记录在这里
 * @author yinwenjie
 */
@TableName("dms_sale_policy_limit")
@Entity
@Table(name = "dms_sale_policy_limit" , indexes = @Index(columnList = "tenant_code , sale_policy_code , limit_strategy_code" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_limit", comment = "促销政策/销售策略 绑定的需要使用的限量政策")
public class SalePolicyLimit extends TenantEntity {
  private static final long serialVersionUID = -3941772683050842091L; 
  /**
   * 优惠政策业务编号
   */
  @Column(name = "sale_policy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '优惠政策业务编号'")
  @ApiModelProperty("优惠政策业务编号")
  private String salePolicyCode;
  /**
   * 限量政策业务编号（对应某个SalePolicyLimitStrategy接口的具体实现类，getLimitStrategyCode()方法所返回的值）
   */
  @Column(name = "limit_strategy_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '限量政策业务编号（对应某个SalePolicyLimitStrategy接口的具体实现类，getLimitStrategyCode()方法所返回的值）'")
  @ApiModelProperty("限量政策业务编号（对应某个SalePolicyLimitStrategy接口的具体实现类，getLimitStrategyCode()方法所返回的值）")
  private String limitStrategyCode; 
  /**
   * 促销政策/销售策略对应的促销规则执行变量-设定的K-V值
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY , mappedBy = "salePolicyLimit")
  @ApiModelProperty("对应设定的各个变量值") 
  private Set<SalePolicyLimitVar> limitVars;
  public String getSalePolicyCode() {
    return salePolicyCode;
  }
  public void setSalePolicyCode(String salePolicyCode) {
    this.salePolicyCode = salePolicyCode;
  }
  public String getLimitStrategyCode() {
    return limitStrategyCode;
  }
  public void setLimitStrategyCode(String limitStrategyCode) {
    this.limitStrategyCode = limitStrategyCode;
  }
  public Set<SalePolicyLimitVar> getLimitVars() {
    return limitVars;
  }
  public void setLimitVars(Set<SalePolicyLimitVar> limitVars) {
    this.limitVars = limitVars;
  }
}