package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

@TableName("dms_sale_policy_limit_var")
@Entity
@Table(name = "dms_sale_policy_limit_var" , indexes = @Index(columnList = "sale_policy_limit_id , variable_name" , unique = true))
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_limit_var", comment = "政策类型执行器下的变量信息")
public class SalePolicyLimitVar extends UuidEntity {
  private static final long serialVersionUID = -5186283711498009351L;
  /**
   * 关联的优惠政策限量政策信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "sale_policy_limit_id" , nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("关联的优惠政策限量政策信息")
  private SalePolicyLimit salePolicyLimit;
  /**
   * 在JPA中只读性质的“关联的优惠政策限量政策信息”技术编码
   */
  @Column(name = "sale_policy_limit_id" , nullable = false , length = 255 , insertable = false , updatable = false)
  @ApiModelProperty("变量名")
  private String salePolicyLimitId;
  /**
   * 变量名（满足一般的变量命名规则）
   */
  @Column(name = "variable_name" , nullable = false , length = 32, columnDefinition = "VARCHAR(32) COMMENT '变量名'")
  @ApiModelProperty("变量名")
  private String variableName;
  /**
   * 变量类型，1：boolean、2：小数；3：整数；4：字符串；
   */
  @Column(name = "variable_type" , nullable = false, columnDefinition = "INT(11) COMMENT '1：boolean、2：小数；3：整数；4：字符串；'")
  @ApiModelProperty("变量类型，1：boolean、2：小数；3：整数；4：字符串")
  private Integer variableType;
  /**
   * 变量值
   */
  @Column(name = "variable_value" , nullable = false , length = 64, columnDefinition = "VARCHAR(64) COMMENT '变量值'")
  @ApiModelProperty("变量值")
  private String variableValue;
  public SalePolicyLimit getSalePolicyLimit() {
    return salePolicyLimit;
  }
  public void setSalePolicyLimit(SalePolicyLimit salePolicyLimit) {
    this.salePolicyLimit = salePolicyLimit;
  }
  public String getSalePolicyLimitId() {
    return salePolicyLimitId;
  }
  public void setSalePolicyLimitId(String salePolicyLimitId) {
    this.salePolicyLimitId = salePolicyLimitId;
  }
  public String getVariableName() {
    return variableName;
  }
  public void setVariableName(String variableName) {
    this.variableName = variableName;
  }
  public Integer getVariableType() {
    return variableType;
  }
  public void setVariableType(Integer variableType) {
    this.variableType = variableType;
  }
  public String getVariableValue() {
    return variableValue;
  }
  public void setVariableValue(String variableValue) {
    this.variableValue = variableValue;
  }
}