package com.biz.crm.dms.business.policy.local.entity;

import java.math.BigDecimal;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 促销政策/销售策略正式执行时，被记录的流水信息
 * @author yinwenjie
 */
@Getter
@Setter
@TableName("dms_sale_policy_record")
@Entity
@Table(name = "dms_sale_policy_record", indexes = {@Index(columnList = "tenant_code, bill_code, customer_code ", unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record", comment = "促销政策/销售策略正式执行时，被记录的流水信息")
public class SalePolicyRecord extends TenantFlagOpEntity {
  private static final long serialVersionUID = 417604669076455404L;
  /**
   * 票据号（包含但不仅限于订单号）
   */
  @Column(name = "bill_code", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '票据号（包含但不仅限于订单号）'")
  @ApiModelProperty("票据号（包含但不仅限于订单号）")
  private String billCode;
  /**
   * 客户编码
   */
  @Column(name = "customer_code", length = 32, nullable = false, columnDefinition = "VARCHAR(32) COMMENT '客户编码'")
  @ApiModelProperty("客户编码")
  private String customerCode;
  /**
   * 符合优惠政策本次执行的所有本品信息（只记录编号，多个以“,”分割）
   */
  @Column(name = "product_codes" , length = 2048 , nullable = false, columnDefinition = "VARCHAR(2048) COMMENT '符合优惠政策本次执行的所有本品信息（只记录编号，多个以“,”分割）'")
  @ApiModelProperty("符合优惠政策本次执行的所有本品信息（只记录编号，多个以“,”分割）")
  private String productCodes;
  /**
   * 符合优惠政策本次执行的所有优惠政策信息（只记录编号，多个以“,”分割）
   */
  @Column(name = "sale_policy_codes" , length = 512 , nullable = false, columnDefinition = "VARCHAR(512) COMMENT '符合优惠政策本次执行的所有优惠政策信息（只记录编号，多个以“,”分割）'")
  @ApiModelProperty("符合优惠政策本次执行的所有优惠政策信息（只记录编号，多个以“,”分割）")
  private String salePolicyCodes;
  /**
   * 整张单据的初始价格（即所有计算开始前的价格）
   */
  @Column(name = "init_total_amount" , nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '整张单据的初始价格（即所有计算开始前的价格）'")
  @ApiModelProperty("整张单据的初始价格（即所有计算开始前的价格）")
  private BigDecimal initTotalAmount;
  /**
   * 整张单据的初始数量（即所有计算开始前的数量）
   */
  @Column(name = "init_total_number" , nullable = false, columnDefinition = "INT(11) COMMENT '整张单据的初始数量（即所有计算开始前的数量）'")
  @ApiModelProperty("整张单据的初始数量（即所有计算开始前的数量）")
  private Integer initTotalNumber;
  /**
   * 该属性表示在进行优惠政策执行后的分摊过程中，是否进行揉价
   */
  @Column(name = "kneading" , nullable = false, columnDefinition = "BIT(1) COMMENT '该属性表示在进行优惠政策执行后的分摊过程中，是否进行揉价'")
  @ApiModelProperty("该属性表示在进行优惠政策执行后的分摊过程中，是否进行揉价")
  private Boolean kneading;
  /**
   * 符合优惠政策本次执行的优惠政策执行顺序
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "salePolicyRecord")
  @ApiModelProperty("符合优惠政策本次执行的优惠政策执行顺序")
  private Set<SalePolicyRecordStepPolicy> salePolicyRecordStepPolicys;
  
  /**
   * 优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "salePolicyRecord")
  @ApiModelProperty("优惠政策执行流水中的初始化商品可能被人为指定的优惠政策信息。")
  private Set<SalePolicyRecordProductSelectedPolicy> salePolicyRecordProductSelectedPolicys;
  /**
   * 可能关联的最初执行时包括，但最终未被执行的优惠政策，以及对应的未被执行的原因。
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "salePolicyRecord")
  @ApiModelProperty("可能关联的最初执行时包括，但最终未被执行的优惠政策，以及对应的未被执行的原因。")
  private Set<SalePolicyRecordExcludePolicy> salePolicyRecordExcludePolicys;
  /**
   * 促销政策/优惠政策中本品优惠情况明细
   */
  @TableField(exist = false)
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "salePolicyRecord")
  @ApiModelProperty("促销政策/优惠政策中本品优惠情况明细")
  private Set<SalePolicyRecordProduct> salePolicyRecordProducts;
}
