package com.biz.crm.dms.business.policy.local.entity;

import java.math.BigDecimal;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

/**
 * 促销政策/优惠政策中赠品流水记录
 * 
 * @author pengxi yinwenjie
 * @date 2022/01/14
 */
@Getter
@Setter
@TableName("dms_sale_policy_record_gift")
@Entity
@Table(name = "dms_sale_policy_record_gift")
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_record_gift", comment = "促销政策/优惠政策中赠品流水记录")
public class SalePolicyRecordGift extends UuidEntity {
  private static final long serialVersionUID = -1002173307203995673L;
  /**
   * 关联的本品信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "record_product_id", nullable = false)
  @TableField(exist = false)
  @ApiModelProperty("关联的本品信息")
  private SalePolicyRecordProduct salePolicyRecordProduct;
  /**
   * 在JPA中只读性质的“关联的本品记录ID”技术编码
   */
  @Column(name = "record_product_id", nullable = false, length = 255, insertable = false, updatable = false, columnDefinition = "VARCHAR(32) COMMENT '关联的本品记录ID'")
  @ApiModelProperty("关联的本品记录ID")
  private String recordProductId;
  /**
   * 赠品编码
   */
  @Column(name = "gift_code", nullable = false, length = 32, columnDefinition = "VARCHAR(64) COMMENT '赠品编码'")
  @ApiModelProperty("赠品编码")
  private String giftCode;
  /**
   * 赠品名称
   */
  @Column(name = "gift_name", nullable = false, length = 255, columnDefinition = "VARCHAR(255) COMMENT '赠品名称'")
  @ApiModelProperty("赠品名称")
  private String giftName;
  /** 
   * 赠品数量，只能为整数 
   * */
  @ApiModelProperty("赠品数量，只能为整数 ")
  @Column(name = "quantity" , nullable = false, columnDefinition = "INT(11) COMMENT '赠品数量，只能为整数'")
  private Integer quantity;
  /** 
   * 赠品价值小计 
   * */
  @Column(name = "subtotal_amount", nullable = false, columnDefinition = "DECIMAL(20,4) COMMENT '赠品价值小计'")
  @ApiModelProperty("赠品价值小计 ")
  private BigDecimal subtotalAmount;
}
