package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * 促销政策/销售策略 促销门槛的详细商品门槛信息，也就是需求设计中“只有多个商品的总价达到1000，才能进行促销，每一个商品的最低要求是100”的需求点
 * @author yinwenjie
 */
@TableName("dms_sale_policy_threshold_detail")
@Entity
@Table(name = "dms_sale_policy_threshold_detail" , indexes = {@Index(columnList = "sale_policy_threshold_id , threshold_detail_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_threshold_detail", comment = "促销政策/销售策略 促销门槛的详细商品门槛信息")
public class SalePolicyThresholdDetail extends UuidEntity {
  private static final long serialVersionUID = 6187336116160978659L;
  /**
   * 关联的优惠政策门槛信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "sale_policy_threshold_id" , nullable = false)
  @TableField(exist = false)
  private SalePolicyThreshold salePolicyThreshold;
  /**
   * 关联的优惠政策门槛技术编号信息（在JPA的操作过程中，该属性只能只读）
   */
  @Column(name = "sale_policy_threshold_id" , length = 255 , nullable = false , updatable = false , insertable = false)
  @ApiModelProperty("关联的优惠政策门槛技术编号信息（在JPA的操作过程中，该属性只能只读）")
  private String salePolicyThresholdId;
  /**
   * 门槛详情业务编号，门槛详情业务编号可能就是优惠政策编号，也可能是优惠政策编号_商品编号，保证每个租户下、每个优惠政策下，该值需要唯一
   */
  @Column(name = "threshold_detail_code" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '门槛详情业务编号，门槛详情业务编号可能就是优惠政策编号，也可能是优惠政策编号_商品编号，保证每个租户下、每个优惠政策下，该值需要唯一'")
  @ApiModelProperty("门槛业务编号")
  private String thresholdDetailCode;
  /**
   * 门槛所包含商品的方式：1、包含当前优惠政策中的所有商品；2、包括固定的数量、固定的商品</br>
   * 默认为2;
   */
  @Column(name = "include_type" , nullable = false, columnDefinition = "INT(11) COMMENT '门槛所包含商品的方式：1、包含当前优惠政策中的所有商品；2、包括固定的数量、固定的商品'")
  @ApiModelProperty("门槛所包含商品的方式：1、包含当前优惠政策中的所有商品；2、包括固定的数量、固定的商品")
  private Integer includeType = 2;
  /**
   * 门槛所包括的固定商品的数量，默认为0
   */
  @Column(name = "include_number" , nullable = false, columnDefinition = "INT(11) COMMENT '门槛所包括的固定商品的数量，默认为0'")
  @ApiModelProperty("门槛所包括的固定商品的数量，默认为0")
  private Integer includeNumber = 0;
  /**
   * 商品门槛信息<br>
   * （不一定是includeType==2且includeNumber==0时，才会有这些信息）。</br>
   * 只要某个商品需要必须包括或者存在最低限价，就有这个明细信息
   */
  @TableField(exist = false)
  @ApiModelProperty(name="thresholdProducts" , value="可能关联的商品门槛信息" , required=false , hidden=true)
  @OneToMany(mappedBy = "thresholdDetail" , fetch = FetchType.LAZY)
  private Set<SalePolicyThresholdProduct> thresholdProducts;
  public SalePolicyThreshold getSalePolicyThreshold() {
    return salePolicyThreshold;
  }
  public void setSalePolicyThreshold(SalePolicyThreshold salePolicyThreshold) {
    this.salePolicyThreshold = salePolicyThreshold;
  }
  public String getSalePolicyThresholdId() {
    return salePolicyThresholdId;
  }
  public void setSalePolicyThresholdId(String salePolicyThresholdId) {
    this.salePolicyThresholdId = salePolicyThresholdId;
  }
  public String getThresholdDetailCode() {
    return thresholdDetailCode;
  }
  public void setThresholdDetailCode(String thresholdDetailCode) {
    this.thresholdDetailCode = thresholdDetailCode;
  }
  public Integer getIncludeType() {
    return includeType;
  }
  public void setIncludeType(Integer includeType) {
    this.includeType = includeType;
  }
  public Integer getIncludeNumber() {
    return includeNumber;
  }
  public void setIncludeNumber(Integer includeNumber) {
    this.includeNumber = includeNumber;
  }
  public Set<SalePolicyThresholdProduct> getThresholdProducts() {
    return thresholdProducts;
  }
  public void setThresholdProducts(Set<SalePolicyThresholdProduct> thresholdProducts) {
    this.thresholdProducts = thresholdProducts;
  }
}
