package com.biz.crm.dms.business.policy.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.UuidEntity;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

/**
 * 促销政策/销售策略 促销门槛的详细商品门槛信息，也就是需求设计中“只有多个商品的总价达到1000，才能进行促销，每一个商品的最低要求是100”的需求点
 * @author yinwenjie
 */
@TableName("dms_sale_policy_threshold_product")
@Entity
@Table(name = "dms_sale_policy_threshold_product" , indexes = {@Index(columnList = "threshold_detail_id , product_code" , unique = true)})
@org.hibernate.annotations.Table(appliesTo = "dms_sale_policy_threshold_product", comment = "促销政策/销售策略 促销门槛的详细商品门槛信息")
public class SalePolicyThresholdProduct extends UuidEntity {
  private static final long serialVersionUID = 6187336116160978659L;
  /**
   * 关联的优惠政策门槛信息
   */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "threshold_detail_id" , nullable = false)
  @TableField(exist = false)
  private SalePolicyThresholdDetail thresholdDetail;
  /**
   * 关联的优惠政策门槛技术编号信息（在JPA的操作过程中，该属性只能只读）
   */
  @Column(name = "threshold_detail_id" , length = 255 , nullable = false , updatable = false , insertable = false)
  @ApiModelProperty("关联的优惠政策门槛技术编号信息（在JPA的操作过程中，该属性只能只读）")
  private String thresholdDetailId;
  /**
   * 该商品门槛是否必然包括
   */
  @Column(name = "certain" , length = 128 , nullable = false, columnDefinition = "VARCHAR(128) COMMENT '该商品门槛是否必然包括'")
  @ApiModelProperty("该商品门槛是否必然包括")
  private Boolean certain;
  /**
   * 商品门槛单位：（ 1：总金额；2：数量）
   */
  @Column(name = "threshold_unit" , nullable = false, columnDefinition = "INT(11) COMMENT '商品门槛单位：（ 1：总金额；2：数量）'")
  @ApiModelProperty("商品门槛单位：（ 1：总金额；2：数量）")
  private Integer thresholdUnit;
  /**
   * 该商品门槛的数量值（单位由thresholdUnit）属性决定
   */
  @Column(name = "threshold_number" , nullable = false, columnDefinition = "INT(11) COMMENT '该商品门槛的数量值（单位由thresholdUnit）属性决定'")
  @ApiModelProperty("该商品门槛的数量值（单位由thresholdUnit）属性决定")
  private Integer thresholdNumber;
  
  /** 商品编码 */
  @Column(name = "product_code", nullable = false , length = 128, columnDefinition = "VARCHAR(128) COMMENT '商品编码'")
  @ApiModelProperty("商品编码")
  private String productCode;

  public SalePolicyThresholdDetail getThresholdDetail() {
    return thresholdDetail;
  }

  public void setThresholdDetail(SalePolicyThresholdDetail thresholdDetail) {
    this.thresholdDetail = thresholdDetail;
  }

  public String getThresholdDetailId() {
    return thresholdDetailId;
  }

  public void setThresholdDetailId(String thresholdDetailId) {
    this.thresholdDetailId = thresholdDetailId;
  }

  public Boolean getCertain() {
    return certain;
  }

  public void setCertain(Boolean certain) {
    this.certain = certain;
  }

  public Integer getThresholdUnit() {
    return thresholdUnit;
  }

  public void setThresholdUnit(Integer thresholdUnit) {
    this.thresholdUnit = thresholdUnit;
  }

  public Integer getThresholdNumber() {
    return thresholdNumber;
  }

  public void setThresholdNumber(Integer thresholdNumber) {
    this.thresholdNumber = thresholdNumber;
  }

  public String getProductCode() {
    return productCode;
  }

  public void setProductCode(String productCode) {
    this.productCode = productCode;
  }
}
