package com.biz.crm.dms.business.policy.local.limitstrategy;

import com.biz.crm.dms.business.policy.local.context.DefaultPolicyExecuteContext;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecord;
import com.biz.crm.dms.business.policy.local.service.SalePolicyRecordService;
import com.biz.crm.dms.business.policy.local.vo.SalePolicyLimitVo;
import com.biz.crm.dms.business.policy.sdk.context.AbstractCycleExecuteContext;
import com.biz.crm.dms.business.policy.sdk.context.AbstractPolicyExecuteContext;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyLimitStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyLimitInfo;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Set;

/**
 * 四、本政策每客每单商品数量上限策略
 *
 * @author pengxi
 * @date 2022/01/11
 */
@Slf4j
public abstract class AbstractGiftCustomerBillQuantityLimitStrategy extends AbstractBaseSalePolicyLimitStrategy implements SalePolicyLimitStrategy<SalePolicyLimitVo> {

  @Autowired(required = false)
  private SalePolicyRecordService salePolicyRecordService;

  /**
   * 取得本政策每客每单维度的商品数量
   */
  @Override
  public void preValidate(AbstractPolicyExecuteContext policyExecuteContext, AbstractCycleExecuteContext cycleExecuteContext, SalePolicyVo currentSalePolicy, AbstractSalePolicyLimitInfo salePolicyLimitInfo) {
    // 1、
    String varValue = super.getVarValue(salePolicyLimitInfo);
    if (varValue == null) {
      log.warn("请设置本政策每客每单商品数量上限！");
      return;
    }
    // 2、
    DefaultPolicyExecuteContext executeContext = (DefaultPolicyExecuteContext)policyExecuteContext;
    Set<SalePolicyRecord> salePolicyRecords = salePolicyRecordService.findByTenantCodeAndSalePolicyCodeAndCustomerCodeAndBillCode(
        executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode(), executeContext.getCustomerCode(), executeContext.getRelevanceCode());
    log.info("AbstractGiftCustomerBillQuantityLimitStrategy：tenantCode={}, salePolicyCode={}, customerCode={}, billCode={}", executeContext.getTenantCode(), currentSalePolicy.getSalePolicyCode(), executeContext.getCustomerCode(), executeContext.getRelevanceCode());
    super.quantityValidateGift(policyExecuteContext, cycleExecuteContext, currentSalePolicy, varValue, salePolicyRecords);
  }
}
