package com.biz.crm.dms.business.policy.local.notifier;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;

import org.redisson.api.listener.MessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;

/**
 * 当优惠政策模块收到redis订阅消息，说明当前桶下的某个进程中，已经发生了优惠政策（全局）信息的变化。
 * @author yinwenjie
 */
@Component("CacheRedisMessageForSalePolicyGlobalListenerImpl")
public class CacheRedisMessageForSalePolicyGlobalListenerImpl implements MessageListener<String> {

  @Autowired(required = false)
  private SalePolicyCacheLoadingService salePolicyCacheLoadingService;
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(CacheRedisMessageForSalePolicyGlobalListenerImpl.class);
  
  // 注意，这里是tenantCode信息
  @Override
  public void onMessage(CharSequence channel, String tenantCode) {
    LOGGER.info("sale policy (" + tenantCode + ") notifing ......");
    // 由于通知发过来后，另外的进程修改数据表信息的事务可能还没有提交。
    // 所以需要阻塞1秒钟，再进行缓存重新加载（TODO 临时的解决办法）
    LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(1000));
    this.salePolicyCacheLoadingService.reloadingCache(tenantCode);
  } 
} 
