package com.biz.crm.dms.business.policy.local.notifier;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.biz.crm.dms.business.policy.local.service.task.SalePolicyCacheLoadingService;
import com.bizunited.nebula.init.service.InitProcessEnvironmentService;

/**
 * 应用系统启动时，进行优惠政策信息的缓存加载，主要是default顶级租户下的default二级租户信息
 * @author yinwenjie
 */
@Component
public class SalePolicyCacheInitProcessEnvironmentService implements InitProcessEnvironmentService {

  @Autowired(required = false)
  private SalePolicyCacheLoadingService salePolicyCacheLoadingService;
  
  @Override
  public void initForAppCode(String appCode) {
    this.salePolicyCacheLoadingService.reloadingCache("default");
  }

  @Override
  public boolean doInitForAppCode(String appCode) {
    return StringUtils.equals(appCode, "default");
  }
}
