package com.biz.crm.dms.business.policy.local.notifier;

import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import com.biz.crm.dms.business.policy.local.scopestrategy.OrgForSalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.AbstractSalePolicyCustomerScopeInfo;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventBatchDto;
import com.biz.crm.mdm.business.org.sdk.dto.OrgEventDto;
import com.biz.crm.mdm.business.org.sdk.event.OrgEventListener;
import com.bizunited.nebula.common.util.tenant.TenantUtils;

/**
 * 一旦MDM中组织机构主数据发生变化，那么和这个组织机构所关联的优惠政策信息，也需要发生变化
 * @author yinwenjie
 */
@Component
public class SalePolicyForOrgEventListener implements OrgEventListener {

  @Autowired(required = false)
  private List<SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo>> salePolicyCustomerScopeStrategies;

  @Override
  public void onDeleteBatch(OrgEventBatchDto orgEventBatchDto) {
    /*
     * 当组织机构删除时，这些组织机构对应的和优惠政策的关联性也要进行删除，并且缓存需要重新加载
     * */
    SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
    if(currentSalePolicyCustomerScopeStrategy == null) {
      return;
    }
    // 进行删除
    String tenantCode = TenantUtils.getTenantCode();
    String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
    if(currentOrgCodes == null || currentOrgCodes.length == 0) {
      return;
    }
    currentSalePolicyCustomerScopeStrategy.onDelete(tenantCode,currentOrgCodes);
  }

  @Override
  public void onEnableBatch(OrgEventBatchDto orgEventBatchDto) {
    /*
     * 当组织机构被禁用，或者被启用时，这些组织机构对应的和优惠政策的关联信息，也需要进行变化
     * */
    SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
    if(currentSalePolicyCustomerScopeStrategy == null) {
      return;
    }
    // 进行删除
    String tenantCode = TenantUtils.getTenantCode();
    String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
    if(currentOrgCodes == null || currentOrgCodes.length == 0) {
      return;
    }
    currentSalePolicyCustomerScopeStrategy.onEffective(tenantCode,currentOrgCodes);
  }

  @Override
  public void onDisableBatch(OrgEventBatchDto orgEventBatchDto) {
    SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = this.currentSalePolicyCustomerScopeStrategy();
    if(currentSalePolicyCustomerScopeStrategy == null) {
      return;
    }
    // 进行删除
    String tenantCode = TenantUtils.getTenantCode();
    String[] currentOrgCodes = this.currentOrgCodes(orgEventBatchDto);
    if(currentOrgCodes == null || currentOrgCodes.length == 0) {
      return;
    }
    currentSalePolicyCustomerScopeStrategy.onInvalid(tenantCode,currentOrgCodes);
  }
  
  private SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy() {
    SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> currentSalePolicyCustomerScopeStrategy = null;
    for (SalePolicyCustomerScopeStrategy<? extends AbstractSalePolicyCustomerScopeInfo> salePolicyCustomerScopeStrategy : salePolicyCustomerScopeStrategies) {
      if(!StringUtils.equals(salePolicyCustomerScopeStrategy.getScopeType() , OrgForSalePolicyCustomerScopeStrategy.SCOPE_TYPE)) {
        continue;
      }
      currentSalePolicyCustomerScopeStrategy = salePolicyCustomerScopeStrategy;
    }
    return currentSalePolicyCustomerScopeStrategy;
  }
  
  private String[] currentOrgCodes(OrgEventBatchDto orgEventBatchDto) {
    List<OrgEventDto> orgEvents = orgEventBatchDto.getOrgEventDtoList();
    if(CollectionUtils.isEmpty(orgEvents)) {
      return null;
    }
    String[] orgCodes = orgEvents.stream().filter(item -> StringUtils.isNotBlank(item.getOrgCode())).map(OrgEventDto::getOrgCode).toArray(String[]::new);
    return orgCodes;
  }
  
  @Override
  public void onUpdate(OrgEventDto orgEventDto) {
    // TODO 不适用
  }
  
  @Override
  public void onDelete(List<String> orgCodes) {
    // TODO 不适用
  }
}
