package com.biz.crm.dms.business.policy.local.notifier;

import com.biz.crm.common.log.sdk.dto.CrmBusinessLogDto;
import com.biz.crm.common.log.sdk.enums.OperationTypeEunm;
import com.biz.crm.common.log.sdk.service.CrmBusinessLogVoService;
import com.biz.crm.dms.business.policy.sdk.dto.SalePolicyLogDto;
import com.biz.crm.dms.business.policy.sdk.event.SalePolicyLogEventListener;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 销售政策impl日志事件侦听器
 *
 * @author hefan
 * @date 2022/05/26
 */
@Component
public class SalePolicyLogEventListenerImpl implements SalePolicyLogEventListener {

  @Autowired(required = false)
  private CrmBusinessLogVoService crmBusinessLogVoService;

  @Override
  public void onCreate(SalePolicyLogDto salePolicyLogDto) {
    this.saveRecord(salePolicyLogDto, OperationTypeEunm.CREATE);
  }

  @Override
  public void onUpdate(SalePolicyLogDto salePolicyLogDto) {
    this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
  }

  @Override
  public void OnEnable(SalePolicyLogDto salePolicyLogDto) {
    this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
  }

  @Override
  public void OnDisable(SalePolicyLogDto salePolicyLogDto) {
    this.saveRecord(salePolicyLogDto, OperationTypeEunm.UPDATE);
  }

  @Override
  public void OnDelete(SalePolicyLogDto salePolicyLogDto) {
    this.saveRecord(salePolicyLogDto, OperationTypeEunm.DELETE);
  }

  /**
   * 保存日志记录
   *
   * @param salePolicyLogDto 销售政策模板日志dto
   * @param operationTypeEunm                   更新
   */
  private void saveRecord(SalePolicyLogDto salePolicyLogDto, OperationTypeEunm operationTypeEunm) {
    SalePolicyVo original = salePolicyLogDto.getOriginal();
    SalePolicyVo newest = salePolicyLogDto.getNewest();
    if (ObjectUtils.isEmpty(original) && ObjectUtils.isEmpty(newest)) {
      throw new RuntimeException("记录操作日志时，没有可比较信息");
    }
    String onlyKey;
    if (ObjectUtils.isEmpty(original)) {
      onlyKey = newest.getId();
    } else {
      onlyKey = original.getId();
    }
    CrmBusinessLogDto crmBusinessLogDto = new CrmBusinessLogDto();
    crmBusinessLogDto.setOperationType(operationTypeEunm.getDictCode());
    crmBusinessLogDto.setOnlyKey(onlyKey);
    crmBusinessLogDto.setAppCode(TenantUtils.getAppCode());
    crmBusinessLogDto.setTenantCode(TenantUtils.getTenantCode());
    crmBusinessLogDto.setOldObject(original);
    crmBusinessLogDto.setNewObject(newest);
    crmBusinessLogVoService.handleSave(crmBusinessLogDto);
  }
}
