package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 利用JPA完成的数据持久层查询（和优惠政策标品默认的执行器信息有关）
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyExecutorJpaRepository
        extends 
        JpaRepository<SalePolicyExecutor, String>,
        JpaSpecificationExecutor<SalePolicyExecutor> {
  
  /**
   * 按照指定的优惠政策业务编码和执行编码，在指定的二级租户范围内查询优惠政策执行详情信息（包括关联的阶梯和阶梯变量信息）
   * @param salePolicyCode 指定的优惠政策业务编码
   * @param executorCode 指定的执行器业务编号
   * @param tenantCode 指定的二级租户
   * @return
   */
  @Query("select distinct s from SalePolicyExecutor s "
      + " left join fetch s.salePolicyExecutorLadders sl "
      + " left join fetch sl.executorLadderVars slv "
      + " left join fetch sl.executorLadderGifts slg "
      + " where s.salePolicyCode = :salePolicyCode and s.executorCode = :executorCode and s.tenantCode = :tenantCode")
  public SalePolicyExecutor findBySalePolicyCodeAndExecutorCode(@Param("salePolicyCode") String salePolicyCode, @Param("executorCode") String executorCode, @Param("tenantCode") String tenantCode);

  /**
   * 按照指定的优惠政策业务编码，在指定的二级租户范围内查询优惠政策执行详情信息（包括关联的阶梯和阶梯变量信息，且可能有多个）
   * @param salePolicyCode 指定的优惠政策业务编码
   * @param tenantCode 指定的二级租户
   * @return
   */
  @Query("select distinct s from SalePolicyExecutor s "
      + " inner join fetch s.salePolicyExecutorLadders sl "
      + " inner join fetch sl.executorLadderVars slv "
      + " left join fetch sl.executorLadderGifts slg "
      + " where s.salePolicyCode = :salePolicyCode and s.tenantCode = :tenantCode and s.executeStrategyCode = :executeStrategyCode ")
  public Set<SalePolicyExecutor> findBySalePolicyCodeAndExecuteStrategyCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode , @Param("executeStrategyCode") String executeStrategyCode);
} 
