package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutor;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimit;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 和标品中默认的优惠政策限量门槛信息有关的数据层功能汇总
 * @author yinwenjie
 */
@Repository
public interface SalePolicyLimitJpaRepository
    extends
      JpaRepository<SalePolicyExecutor, String>,
      JpaSpecificationExecutor<SalePolicyExecutor> {
  /**
   * 按照优惠政策业务编码和二级租户信息、限量政策业务编号进行符合要求的限量信息的查询
   * @param salePolicyCode 指定的优惠政策业务编码
   * @param tenantCode 指定的二级租户信息
   * @param limitStrategyCode 限量政策业务编号
   * @return
   */
  @Query(" select distinct spl from SalePolicyLimit spl "
      + " left join fetch spl.limitVars l "
      + " where spl.salePolicyCode = :salePolicyCode AND spl.limitStrategyCode = :limitStrategyCode AND spl.tenantCode = :tenantCode ")
  public SalePolicyLimit findBySalePolicyCodeAndTenantCodeAndLimitStrategyCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode, @Param("limitStrategyCode") String limitStrategyCode);
}
