package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyLimitVar;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyLimitVarMapper;
import org.springframework.stereotype.Component;

/**
 * 和标品中默认的优惠政策限量门槛变量信息有关的数据层功能汇总
 * @author yinwenjie
 */
@Component
public class SalePolicyLimitVarRepository extends ServiceImpl<SalePolicyLimitVarMapper, SalePolicyLimitVar> {
  /**
   * 按照关联的优惠政策限量政策信息的技术id，进行变量信息的删除
   * @param salePolicyLimitId 优惠政策执行信息的id信息
   */
  public void deleteBySalePolicyLimit(String salePolicyLimitId) {
    LambdaQueryWrapper<SalePolicyLimitVar> lambdaQuery = Wrappers.<SalePolicyLimitVar>lambdaQuery();
    lambdaQuery.eq(SalePolicyLimitVar::getSalePolicyLimitId, salePolicyLimitId);
    this.baseMapper.delete(lambdaQuery);
  }
}
