package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyProduct;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 利用JPA完成的数据持久层查询（和优惠政策商品本品信息有关）
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyProductJpaRepository
        extends 
        JpaRepository<SalePolicyProduct, String>,
        JpaSpecificationExecutor<SalePolicyProduct> {
  
  /**
   * 按照指定的门槛涉及的优惠政策业务编号信息，进行商品本品信息的查询(可能是多个)
   * @param salePolicyCode 指定的优惠政策业务编号 
   * @return
   */
  @Query("from SalePolicyProduct s where s.salePolicyCode = :salePolicyCode and s.tenantCode = :tenantCode order by s.productCode ")
  List<SalePolicyProduct> findBySalePolicyCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode);
}
