package com.biz.crm.dms.business.policy.local.repository;

import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordExcludePolicy;

import com.biz.crm.dms.business.policy.local.mapper.SalePolicyRecordExcludePolicyMapper;

/**
 * @author yinwenjie
 */
@Component
public class SalePolicyRecordExcludePolicyRepository extends ServiceImpl<SalePolicyRecordExcludePolicyMapper, SalePolicyRecordExcludePolicy> {

  public void deleteByRecordId(String recordId) {
    LambdaQueryWrapper<SalePolicyRecordExcludePolicy> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(SalePolicyRecordExcludePolicy::getRecordId, recordId);
    this.baseMapper.delete(lambdaQuery);
  }
}