package com.biz.crm.dms.business.policy.local.repository;

import java.util.List;

import org.springframework.stereotype.Component;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyRecordProduct;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyRecordProductMapper;

/**
 * 促销政策/优惠政策中本品使用记录表的数据层功能汇总
 * @author pengxi yinwenjie
 * @date 2022/01/14
 */
@Component
public class SalePolicyRecordProductRepository extends ServiceImpl<SalePolicyRecordProductMapper, SalePolicyRecordProduct> {
  
  /**
   * 按照促销政策/优惠政策使用记录ID进行已有本品记录信息的刪除操作
   * @param recordId 促销政策/优惠政策使用记录ID
   */
  public void deleteByRecordId(String recordId) {
    LambdaQueryWrapper<SalePolicyRecordProduct> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(SalePolicyRecordProduct::getRecordId, recordId);
    this.baseMapper.delete(lambdaQuery);
  }
  
  /**
   * 按照促销政策/优惠政策使用记录ID，查询对应的本品步进信息
   * @param recordId
   * @return
   */
  public List<SalePolicyRecordProduct> findByRecordId(String recordId) {
    LambdaQueryWrapper<SalePolicyRecordProduct> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(SalePolicyRecordProduct::getRecordId, recordId);
    List<SalePolicyRecordProduct> salePolicyRecordProducts = this.baseMapper.selectList(lambdaQuery);
    return salePolicyRecordProducts;
  }
}