package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyTempleteExecuteStrategy;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyTempleteExecuteStrategyMapper;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * SalePolicyTempleteExecuteStrategy 优惠政策模板关联的执行策略数据(repository)
 * @author yinwenjie
 */
@Component
public class SalePolicyTempleteExecuteStrategyRepository extends ServiceImpl<SalePolicyTempleteExecuteStrategyMapper,  SalePolicyTempleteExecuteStrategy> {
  /**
   * 按照信息关联的优惠政策模板信息，进行删除
   * @param templeteId 优惠政策模板信息
   */
  public void deleteByTempleteId(String templeteId) {
    if(StringUtils.isBlank(templeteId)) {
      return;
    }
    LambdaQueryWrapper<SalePolicyTempleteExecuteStrategy> lambdaQuery = Wrappers.<SalePolicyTempleteExecuteStrategy>lambdaQuery();
    lambdaQuery.eq(SalePolicyTempleteExecuteStrategy::getTempleteId, templeteId);
    this.baseMapper.delete(lambdaQuery);
  }
}
