package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdDetail;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyThresholdDetailMapper;
import com.google.common.collect.Sets;

import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

/**
 * sale_policy 优惠政策中，标品模块使用的优惠政策门槛明细信息数据(repository)
 * @author yinwenjie
 */
@Component
public class SalePolicyThresholdDetailRepository extends ServiceImpl<SalePolicyThresholdDetailMapper, SalePolicyThresholdDetail> {
  @Autowired(required = false)
  private SalePolicyThresholdDetailJpaRepository salePolicyThresholdDetailJpaRepository;
  
  /**
   * 按照优惠政策业务编号和特定的门槛明细业务编号进行查询
   * @param salePolicyCode 指定的优惠政策业务编号
   * @param thresholdDetailCode 指定的门槛明细业务编号
   */
  public SalePolicyThresholdDetail findBySalePolicyCodeAndThresholdDetailCode(String salePolicyCode , String tenantCode , String thresholdDetailCode) {
    return salePolicyThresholdDetailJpaRepository.findBySalePolicyCodeAndThresholdDetailCode(salePolicyCode, tenantCode, thresholdDetailCode);
  }
  
  /**
   * 按照指定的门槛信息业务编号信息，进行门槛详情信息的查询(这里没有关联信息)
   * @param thresholdCode  指定的门槛业务编号
   */
  public Set<SalePolicyThresholdDetail> findBySalePolicyCode(String salePolicyCode, String tenantCode) {
    return this.salePolicyThresholdDetailJpaRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
  }
  
  /**
   * 按照门槛信息的技术id进行查询
   * @param salePolicyThresholdId
   * @return
   */
  public Set<SalePolicyThresholdDetail> findBySalePolicyThresholdId(String salePolicyThresholdId) {
    List<SalePolicyThresholdDetail>  results = this.lambdaQuery().eq(SalePolicyThresholdDetail::getSalePolicyThresholdId, salePolicyThresholdId).list();
    if(CollectionUtils.isEmpty(results)) {
      return null;
    }
    return Sets.newLinkedHashSet(results);
  }
  
  /**
   * 按照特定的优惠政策门槛技术编号，删除所有相关的门槛商品信
   * @param salePolicyThresholdId
   */
  public void deleteBySalePolicyThresholdId(String salePolicyThresholdId) {
    LambdaQueryWrapper<SalePolicyThresholdDetail> lambdaQuery = Wrappers.<SalePolicyThresholdDetail>lambdaQuery();
    lambdaQuery.eq(SalePolicyThresholdDetail::getSalePolicyThresholdId, salePolicyThresholdId);
    this.baseMapper.delete(lambdaQuery);
  }
}
