package com.biz.crm.dms.business.policy.local.repository;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

/**
 * 利用JPA完成的数据持久层查询
 * @author: yinwenjie
 * @version 2.0
 */
@Repository
public interface SalePolicyThresholdJpaRepository
        extends 
        JpaRepository<SalePolicyThreshold, String>,
        JpaSpecificationExecutor<SalePolicyThreshold> {
  
  /**
   * 按照指定的门槛信息业务编号信息，进行门槛基本信息的查询(包括关联信息)
   * @param thresholdCode  指定的门槛业务编号
   */
  @Query("select distinct s from SalePolicyThreshold s "
      + " left join fetch s.thresholdDetails sdd "
      + " left join fetch sdd.thresholdProducts sdp "
      + " where s.tenantCode = :tenantCode and s.salePolicyCode = :salePolicyCode ")
  public SalePolicyThreshold findBySalePolicyCode(@Param("salePolicyCode") String salePolicyCode, @Param("tenantCode") String tenantCode);
}
