package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThresholdProduct;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyThresholdProductMapper;
import org.springframework.stereotype.Component;

/**
 * sale_policy 优惠政策中，标品模块使用的优惠政策门槛商品明细信息数据(repository)，一个门槛详情下可以有一个或者多个门槛商品明细
 * @author yinwenjie
 */
@Component
public class SalePolicyThresholdProductRepository extends ServiceImpl<SalePolicyThresholdProductMapper, SalePolicyThresholdProduct> {
  /**
   * 按照特定的优惠政策门槛技术编号，删除所有相关的门槛商品信
   * @param salePolicyThresholdId
   */
  public void deleteByThresholdDetailId(String thresholdDetailId) {
    LambdaQueryWrapper<SalePolicyThresholdProduct> lambdaQuery = Wrappers.<SalePolicyThresholdProduct>lambdaQuery();
    lambdaQuery
      .eq(SalePolicyThresholdProduct::getThresholdDetailId, thresholdDetailId);
    this.baseMapper.delete(lambdaQuery);
  }
}
