package com.biz.crm.dms.business.policy.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dms.business.policy.local.entity.SalePolicyThreshold;
import com.biz.crm.dms.business.policy.local.mapper.SalePolicyThresholdMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * sale_policy 优惠政策中，标品模块使用的优惠政策门槛信息数据(repository)
 * @author yinwenjie
 */
@Component
public class SalePolicyThresholdRepository extends ServiceImpl<SalePolicyThresholdMapper, SalePolicyThreshold> {
  @Autowired(required = false)
  private SalePolicyThresholdJpaRepository salePolicyThresholdJpaRepository;
  
  /**
   * 按照指定的门槛涉及的优惠政策业务编号信息(可能是多个)，进行门槛基本信息的查询(包括关联信息)
   * @param salePolicyCode 指定的优惠政策业务编号 
   * @return
   */
  public SalePolicyThreshold findBySalePolicyCode(String salePolicyCode , String tenantCode) {
    return this.salePolicyThresholdJpaRepository.findBySalePolicyCode(salePolicyCode, tenantCode);
  }
  
  /**
   * 按照优惠政策门槛技术编号，进行删除
   */
  public void deleteById(String salePolicyThresholdId) {
    LambdaQueryWrapper<SalePolicyThreshold> lambdaQuery = Wrappers.<SalePolicyThreshold>lambdaQuery();
    lambdaQuery.eq(SalePolicyThreshold::getId, salePolicyThresholdId);
    this.baseMapper.delete(lambdaQuery);
  }
}
