package com.biz.crm.dms.business.policy.local.scopestrategy;

import java.util.List;

import com.biz.crm.dms.business.policy.sdk.strategy.SalePolicyCustomerScopeMergeStrategy;
import com.biz.crm.dms.business.policy.sdk.vo.SalePolicyVo;

/**
 * 由标品提供的，用于计算某个优惠政策最终可以作用于哪些客户的有效范围起作用方式。这个方式取的是“并集”<br>
 * 也就是说时只要目前优惠政策的客户匹配判定结果为true，那么整个就为true
 * @author yinwenjie
 */
public class UnionSalePolicyCustomerScopeMergeStrategy implements SalePolicyCustomerScopeMergeStrategy {

  @Override
  public MergeResult merge(List<Boolean> historyMatched, int size, SalePolicyVo currentSalePolicyVo, String currentCustomerCode, boolean currentMatched , String currentScopeType) {
    // 有一个为true，就匹配成功了
    if(currentMatched) {
      return MergeResult.SUCCEEDED;
    }
    // 只有全部为false，才认为匹配失败
    if(size == historyMatched.size()) {
      return MergeResult.FAILED;
    }
    
    // 否则就是不确认匹配是否成功，向后执行后续维度的匹配
    return MergeResult.UNDETERMINED;
  }
}
