package com.biz.crm.dms.business.policy.local.service;

import com.biz.crm.dms.business.policy.local.entity.SalePolicyExecutorLadder;

import java.util.Set;

/**
 * 该服务接口面向SalePolicyExecutorLadder实体
 * 促销政策/销售策略 政策明细阶梯服务接口
 * @author songjingen
 */
public interface SalePolicyExecutorLadderService {

  /**
   * 批量创建促销规则的明细阶梯信息
   * @param salePolicyExecutorLadders 阶梯信息集合
   * @param executeStrategyCode 这条优惠政策执行规则所使用的执行器编码，该编码和某个SalePolicyExecuteStrategy接口具体实现类中的getExecuteStrategyCode()方法返回的值对应
   * @param salePolicyCode 优惠政策业务编号
   * @param salePolicyExecutorId 关联的执行规则基本信息的id
   * @param expression 优惠执行策略表达式
   */
  void createBatch(Set<SalePolicyExecutorLadder> salePolicyExecutorLadders, String executeStrategyCode, String salePolicyCode, String salePolicyExecutorId, String expression);
}
